/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjena.atlas.logging.Log;

public class GraphList {
    private static final Node CAR = RDF.first.asNode();
    private static final Node CDR = RDF.rest.asNode();
    private static final Node NIL = RDF.nil.asNode();

    public static List<Node> listFromMember(GNode gnode) {
        ArrayList<Node> x = new ArrayList<Node>();
        GraphList.listFromMember(gnode, x);
        return x;
    }

    public static void listFromMember(GNode gnode, Collection<Node> acc) {
        Set<GNode> lists = GraphList.findCellsWithMember(gnode);
        block0: for (GNode gn : lists) {
            while (gn != null) {
                GNode gn2 = GraphList.previous(gn);
                if (gn2 == null) {
                    acc.add(gn.node);
                    continue block0;
                }
                gn = gn2;
            }
        }
    }

    private static Set<GNode> findCellsWithMember(GNode gnode) {
        HashSet<GNode> x = new HashSet<GNode>();
        Iterator<Triple> iter = gnode.findable.find(Node.ANY, CAR, gnode.node);
        while (iter.hasNext()) {
            Triple t = iter.next();
            x.add(new GNode(gnode, t.getSubject()));
        }
        NiceIterator.close(iter);
        return x;
    }

    private static GNode previous(GNode gnode) {
        Node n = GraphList.getNodeReverse(gnode, CDR);
        if (n == null) {
            return null;
        }
        return new GNode(gnode, n);
    }

    private static Node getNodeReverse(GNode gnode, Node arc) {
        Triple t = GraphList.getTripleReverse(gnode, arc);
        if (t == null) {
            return null;
        }
        return t.getSubject();
    }

    private static Triple getTripleReverse(GNode gnode, Node arc) {
        Iterator<Triple> iter = gnode.findable.find(Node.ANY, arc, gnode.node);
        if (!iter.hasNext()) {
            return null;
        }
        Triple t = iter.next();
        if (iter.hasNext()) {
            Log.warn(GraphList.class, "Unusual list: two arcs with same property (" + arc + ")");
        }
        NiceIterator.close(iter);
        return t;
    }

    public static List<Node> members(GNode gnode) {
        ArrayList<Node> x = new ArrayList<Node>();
        GraphList.members(gnode, x);
        return x;
    }

    public static void members(GNode gnode, Collection<Node> acc) {
        if (!GraphList.isListNode(gnode)) {
            return;
        }
        while (!GraphList.listEnd(gnode)) {
            Node n = GraphList.car(gnode);
            if (n != null) {
                acc.add(n);
            }
            gnode = GraphList.next(gnode);
        }
    }

    public static int length(GNode gnode) {
        if (!GraphList.isListNode(gnode)) {
            return -1;
        }
        int len = 0;
        while (!GraphList.listEnd(gnode)) {
            ++len;
            gnode = GraphList.next(gnode);
        }
        return len;
    }

    public static int occurs(GNode gnode, Node item) {
        return GraphList.indexes(gnode, item).size();
    }

    public static boolean contains(GNode gnode, Node item) {
        return GraphList.index(gnode, item) >= 0;
    }

    public static Node get(GNode gnode, int idx) {
        if (!GraphList.isListNode(gnode)) {
            return null;
        }
        while (!GraphList.listEnd(gnode)) {
            if (idx == 0) {
                return GraphList.car(gnode);
            }
            gnode = GraphList.next(gnode);
            --idx;
        }
        return null;
    }

    public static int index(GNode gnode, Node value) {
        if (!GraphList.isListNode(gnode)) {
            return -1;
        }
        int idx = 0;
        while (!GraphList.listEnd(gnode)) {
            Node v = GraphList.car(gnode);
            if (v != null && v.equals((Object)value)) {
                return idx;
            }
            gnode = GraphList.next(gnode);
            ++idx;
        }
        return -1;
    }

    public static List<Integer> indexes(GNode gnode, Node value) {
        ArrayList<Integer> x = new ArrayList<Integer>();
        if (!GraphList.isListNode(gnode)) {
            return x;
        }
        int idx = 0;
        while (!GraphList.listEnd(gnode)) {
            Node v = GraphList.car(gnode);
            if (v != null && v.equals((Object)value)) {
                x.add(new Integer(idx));
            }
            gnode = GraphList.next(gnode);
            ++idx;
        }
        return x;
    }

    public static void triples(GNode gnode, Collection<Triple> acc) {
        if (GraphList.listEnd(gnode)) {
            return;
        }
        Triple t = null;
        t = GraphList.getTriple(gnode, CAR);
        if (t != null) {
            acc.add(t);
        }
        if ((t = GraphList.getTriple(gnode, CDR)) != null) {
            acc.add(t);
        }
    }

    public static List<Triple> allTriples(GNode gnode) {
        ArrayList<Triple> x = new ArrayList<Triple>();
        GraphList.allTriples(gnode, x);
        return x;
    }

    public static void allTriples(GNode gnode, Collection<Triple> acc) {
        if (!GraphList.isListNode(gnode)) {
            return;
        }
        while (!GraphList.listEnd(gnode)) {
            GraphList.triples(gnode, acc);
            gnode = GraphList.next(gnode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Node> findAllLists(Graph graph) {
        Triple t;
        HashSet<Node> acc = new HashSet<Node>();
        ExtendedIterator iter = graph.find(Node.ANY, CDR, Node.ANY);
        try {
            while (iter.hasNext()) {
                t = (Triple)iter.next();
                Node node = t.getSubject();
                if (graph.contains(Node.ANY, CDR, node)) continue;
                acc.add(node);
            }
        }
        finally {
            NiceIterator.close((Iterator)iter);
        }
        iter = graph.find(Node.ANY, Node.ANY, NIL);
        try {
            while (iter.hasNext()) {
                t = (Triple)iter.next();
                if (t.getPredicate().equals((Object)CDR)) continue;
                acc.add(NIL);
                break;
            }
        }
        finally {
            NiceIterator.close((Iterator)iter);
        }
        if (graph.contains(NIL, Node.ANY, Node.ANY)) {
            acc.add(NIL);
        }
        return acc;
    }

    public static Node listToTriples(List<Node> list, BasicPattern bgp) {
        Node head;
        if (list.size() == 0) {
            return RDF.Nodes.nil;
        }
        Node n = head = Node.createAnon();
        for (Node elt : list) {
            Node consCell = Node.createAnon();
            Triple t = new Triple(n, RDF.Nodes.rest, consCell);
            Triple t1 = new Triple(consCell, RDF.Nodes.first, elt);
            n = consCell;
            bgp.add(t);
            bgp.add(t1);
        }
        Triple t = new Triple(n, RDF.Nodes.rest, RDF.Nodes.nil);
        bgp.add(t);
        return head;
    }

    private static GNode next(GNode gnode) {
        return new GNode(gnode, GraphList.cdr(gnode));
    }

    private static Node value(GNode gnode) {
        return GraphList.car(gnode);
    }

    public static boolean isListNode(GNode gnode) {
        return gnode.node.equals((Object)NIL) || GraphList.isCons(gnode);
    }

    private static boolean isCons(GNode gnode) {
        return gnode.findable.contains(gnode.node, CDR, null);
    }

    private static boolean listEnd(GNode gnode) {
        return gnode.node == null || gnode.node.equals((Object)NIL);
    }

    private static Node car(GNode gnode) {
        return GraphList.getNode(gnode, CAR);
    }

    private static Node cdr(GNode gnode) {
        return GraphList.getNode(gnode, CDR);
    }

    private static Node getNode(GNode gnode, Node arc) {
        if (GraphList.listEnd(gnode)) {
            return null;
        }
        Triple t = GraphList.getTriple(gnode, arc);
        if (t == null) {
            return null;
        }
        return t.getObject();
    }

    private static Triple getTriple(GNode gnode, Node arc) {
        if (GraphList.listEnd(gnode)) {
            return null;
        }
        Iterator<Triple> iter = gnode.findable.find(gnode.node, arc, Node.ANY);
        if (!iter.hasNext()) {
            return null;
        }
        Triple t = iter.next();
        if (iter.hasNext()) {
            Log.warn(GraphList.class, "Unusual list: two arcs with same property (" + arc + ")");
        }
        NiceIterator.close(iter);
        return t;
    }
}

