/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.buffer.PtrBuffer;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeException;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeBuilder;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeRewriterUtils;
import com.hp.hpl.jena.tdb.index.bplustree.RecordBufferPageLinker;
import com.hp.hpl.jena.tdb.index.bplustree.RecordBufferPagePacker;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorWithBuffer;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPlusTreeRewriter {
    private static Logger log = LoggerFactory.getLogger(BPlusTreeRewriter.class);
    static boolean rebalance = true;
    static boolean debug;
    static boolean materialize;

    public static BPlusTree packIntoBPlusTree(Iterator<Record> iterRecords, BPlusTreeParams bptParams, RecordFactory recordFactory, BlockMgr blkMgrNodes, BlockMgr blkMgrRecords) {
        if (!iterRecords.hasNext()) {
            return BPlusTree.create(bptParams, blkMgrNodes, blkMgrRecords);
        }
        BPlusTree bpt2 = BPlusTree.attach(bptParams, blkMgrNodes, blkMgrRecords);
        BPTreeNode root = bpt2.getNodeManager().createNode(-2);
        int rootId = root.getId();
        if (rootId != 0) {
            log.error("**** Not the root: " + rootId);
            throw new BPTreeException();
        }
        IteratorWithBuffer iter = BPlusTreeRewriter.writePackedDataBlocks(iterRecords, bpt2);
        boolean leafLayer = true;
        while (true) {
            IteratorWithBuffer iter2;
            boolean singleBlock = (iter2 = new IteratorWithBuffer(iter = BPlusTreeRewriter.genTreeLevel(iter, bpt2, leafLayer), 2)).peek(1) == null;
            iter = iter2;
            if (singleBlock) break;
            leafLayer = false;
        }
        Pair pair = (Pair)iter.next();
        if (iter.hasNext()) {
            log.error("**** Building index layers didn't result in a single block");
            return null;
        }
        BPlusTreeRewriter.fixupRoot(root, (Pair<Integer, Record>)pair, bpt2);
        blkMgrNodes.sync();
        blkMgrRecords.sync();
        bpt2 = BPlusTree.create(bptParams, blkMgrNodes, blkMgrRecords);
        return bpt2;
    }

    private static Iterator<Pair<Integer, Record>> writePackedDataBlocks(Iterator<Record> records, final BPlusTree bpt) {
        if (debug) {
            BPlusTreeRewriterUtils.divider();
            System.out.println("---- Data level");
        }
        final RecordBufferPageMgr mgr = bpt.getRecordsMgr().getRecordBufferPageMgr();
        RecordBufferPageLinker iter = new RecordBufferPageLinker(new RecordBufferPagePacker(records, mgr));
        Transform<RecordBufferPage, Pair<Integer, Record>> transform = new Transform<RecordBufferPage, Pair<Integer, Record>>(){

            public Pair<Integer, Record> convert(RecordBufferPage rbp) {
                mgr.put(rbp);
                Record r = rbp.getRecordBuffer().getHigh();
                r = bpt.getRecordFactory().createKeyOnly(r);
                return new Pair((Object)rbp.getId(), (Object)r);
            }
        };
        Object iter2 = Iter.map((Iterator)iter, (Transform)transform);
        if (debug) {
            if (rebalance) {
                System.out.println("Before rebalance (data)");
            }
            iter2 = BPlusTreeRewriterUtils.summarizeDataBlocks(iter2, bpt.getRecordsMgr().getRecordBufferPageMgr());
        }
        if (rebalance) {
            iter2 = new RebalenceDataEnd((Iterator<Pair<Integer, Record>>)iter2, bpt);
        }
        if (materialize && !debug) {
            iter2 = Iter.toList(iter2).iterator();
        }
        if (debug && rebalance) {
            System.out.println("After rebalance (data)");
            iter2 = BPlusTreeRewriterUtils.summarizeDataBlocks(iter2, bpt.getRecordsMgr().getRecordBufferPageMgr());
        }
        return iter2;
    }

    private static Iterator<Pair<Integer, Record>> genTreeLevel(Iterator<Pair<Integer, Record>> iter, BPlusTree bpt, boolean leafLayer) {
        if (debug) {
            BPlusTreeRewriterUtils.divider();
            System.out.println("---- Index level");
        }
        Object iter2 = new BPTreeNodeBuilder(iter, bpt.getNodeManager(), leafLayer, bpt.getRecordFactory());
        if (debug) {
            if (rebalance) {
                System.out.println("Before rebalance (index)");
            }
            iter2 = BPlusTreeRewriterUtils.printIndexBlocks(iter2, bpt.getNodeManager());
        }
        if (rebalance) {
            iter2 = new RebalenceIndexEnd((Iterator<Pair<Integer, Record>>)iter2, bpt, leafLayer);
        }
        if (materialize && !debug) {
            iter2 = Iter.toList((Iterator)iter2).iterator();
        }
        if (debug && rebalance) {
            System.out.println("After rebalance (index)");
            iter2 = BPlusTreeRewriterUtils.printIndexBlocks(iter2, bpt.getNodeManager());
        }
        return iter2;
    }

    private static void fixupRoot(BPTreeNode root, Pair<Integer, Record> pair, BPlusTree bpt2) {
        root.getPtrBuffer().clear();
        root.getRecordBuffer().clear();
        if (debug) {
            BPlusTreeRewriterUtils.divider();
            System.out.printf("** Process root: %s\n", pair);
        }
        BPTreeNode node = bpt2.getNodeManager().getRead((Integer)pair.car(), -2);
        BPlusTreeRewriter.copyBPTreeNode(node, root, bpt2);
        bpt2.getNodeManager().release(node);
    }

    private static void copyBPTreeNode(BPTreeNode nodeSrc, BPTreeNode nodeDst, BPlusTree bpt2) {
        PtrBuffer pBuff = nodeSrc.getPtrBuffer();
        pBuff.copy(0, nodeDst.getPtrBuffer(), 0, pBuff.getSize());
        RecordBuffer rBuff = nodeSrc.getRecordBuffer();
        rBuff.copy(0, nodeDst.getRecordBuffer(), 0, rBuff.getSize());
        nodeDst.setCount(nodeSrc.getCount());
        nodeDst.setIsLeaf(nodeSrc.isLeaf());
        bpt2.getNodeManager().put(nodeDst);
    }

    static {
        materialize = debug = false;
    }

    private static class RebalenceIndexEnd
    extends RebalenceBase {
        private BPlusTree bpt;

        public RebalenceIndexEnd(Iterator<Pair<Integer, Record>> iter, BPlusTree bpt, boolean leafLayer) {
            super(iter);
            this.bpt = bpt;
        }

        @Override
        protected Record rebalance(int id1, Record r1, int id2, Record r2) {
            BPTreeNodeMgr mgr = this.bpt.getNodeManager();
            BPTreeNode node1 = mgr.getWrite(id1, -99);
            BPTreeNode node2 = mgr.getWrite(id2, -99);
            int x = node2.getCount();
            if (node2.getCount() >= this.bpt.getParams().getMinRec()) {
                return null;
            }
            Record splitPoint = r1;
            for (int i = node2.getCount(); i < this.bpt.getParams().getMinRec(); ++i) {
                Record r = splitPoint;
                int ptr = node1.getPtrBuffer().getHigh();
                splitPoint = node1.getRecordBuffer().getHigh();
                node1.getPtrBuffer().removeTop();
                node1.getRecordBuffer().removeTop();
                node1.setCount(node1.getCount() - 1);
                node2.getPtrBuffer().add(0, ptr);
                node2.getRecordBuffer().add(0, r);
                node2.setCount(node2.getCount() + 1);
                if (!debug) continue;
                System.out.printf("-- Shift up: %d %s\n", ptr, r);
            }
            mgr.put(node1);
            mgr.put(node2);
            return splitPoint;
        }
    }

    private static abstract class RebalenceBase
    extends IteratorWithBuffer<Pair<Integer, Record>> {
        protected RebalenceBase(Iterator<Pair<Integer, Record>> iter) {
            super(iter, 2);
        }

        protected final void endReachedInner() {
            Record newSplitPoint;
            Pair pair1 = (Pair)this.peek(0);
            Pair pair2 = (Pair)this.peek(1);
            if (pair1 == null || pair2 == null) {
                return;
            }
            if (debug) {
                System.out.printf("Rebalance: %s %s\n", pair1, pair2);
            }
            if ((newSplitPoint = this.rebalance((Integer)pair1.car(), (Record)pair1.cdr(), (Integer)pair2.car(), (Record)pair2.cdr())) != null) {
                if (debug) {
                    System.out.println("Reset split point: " + pair1.cdr() + " => " + newSplitPoint);
                }
                pair1 = new Pair(pair1.car(), (Object)newSplitPoint);
                if (debug) {
                    System.out.printf("   %s %s\n", pair1, pair2);
                }
                this.set(0, pair1);
            }
        }

        protected abstract Record rebalance(int var1, Record var2, int var3, Record var4);
    }

    private static class RebalenceDataEnd
    extends RebalenceBase {
        private RecordBufferPageMgr mgr;
        private BPlusTree bpt;

        public RebalenceDataEnd(Iterator<Pair<Integer, Record>> iter, BPlusTree bpt) {
            super(iter);
            this.bpt = bpt;
        }

        @Override
        protected Record rebalance(int id1, Record r1, int id2, Record r2) {
            RecordBufferPageMgr mgr = this.bpt.getRecordsMgr().getRecordBufferPageMgr();
            RecordBufferPage page1 = (RecordBufferPage)mgr.getWrite(id1);
            RecordBufferPage page2 = (RecordBufferPage)mgr.getWrite(id2);
            for (int i = page2.getCount(); i < page1.getMaxSize() / 2; ++i) {
                Record r = page1.getRecordBuffer().getHigh();
                page1.getRecordBuffer().removeTop();
                page2.getRecordBuffer().add(0, r);
            }
            mgr.put(page1);
            mgr.put(page2);
            Record splitPoint = page1.getRecordBuffer().getHigh();
            splitPoint = this.bpt.getRecordFactory().createKeyOnly(splitPoint);
            return splitPoint;
        }
    }
}

