/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTableView;
import com.hp.hpl.jena.tdb.solver.stats.Stats;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.bulkloader.Destination;
import com.hp.hpl.jena.tdb.store.bulkloader.LoadMonitor;
import com.hp.hpl.jena.tdb.store.bulkloader.LoaderNodeTupleTable;
import java.io.InputStream;
import java.util.List;
import org.openjena.atlas.event.EventType;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.slf4j.Logger;

public class BulkLoader {
    public static int DataTickPoint = 50000;
    public static long IndexTickPoint = 100000L;
    public static int superTick = 10;
    private static String baseName = "http://openjena.org/TDB/bulkload/event#";
    public static EventType evStartBulkload = new EventType(baseName + "start-bulkload");
    public static EventType evFinishBulkload = new EventType(baseName + "finish-bulkload");
    public static EventType evStartDataBulkload = new EventType(baseName + "start-bulkload-data");
    public static EventType evFinishDataBulkload = new EventType(baseName + "finish-bulkload-data");
    public static EventType evStartIndexBulkload = new EventType(baseName + "start-bulkload-index");
    public static EventType evFinishIndexBulkload = new EventType(baseName + "finish-bulkload-index");
    private static Logger loadLogger = TDB.logLoader;

    public static void loadDefaultGraph(DatasetGraphTDB dsg, List<String> urls, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationDefaultGraph(dsg, showProgress);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadDefaultGraph(DatasetGraphTDB dsg, InputStream input, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationDefaultGraph(dsg, showProgress);
        BulkLoader.loadTriples$(dest, input);
    }

    private static Destination<Triple> destinationDefaultGraph(DatasetGraphTDB dsg, boolean showProgress) {
        NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
        return BulkLoader.destination(dsg, ntt, showProgress);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, List<String> urls, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, InputStream input, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress);
        BulkLoader.loadTriples$(dest, input);
    }

    public static void loadDataset(DatasetGraphTDB dsg, List<String> urls, boolean showProgress) {
        Destination<Quad> dest = BulkLoader.destinationDataset(dsg, showProgress);
        BulkLoader.loadQuads$(dest, urls);
    }

    public static void loadDataset(DatasetGraphTDB dsg, InputStream input, boolean showProgress) {
        Destination<Quad> dest = BulkLoader.destinationDataset(dsg, showProgress);
        BulkLoader.loadQuads$(dest, input);
    }

    private static void loadTriples$(Destination<Triple> dest, List<String> urls) {
        dest.start();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + Utils.nowAsString());
            RiotReader.parseTriples((String)url, dest);
        }
        dest.finish();
    }

    private static void loadTriples$(Destination<Triple> dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + Utils.nowAsString());
        dest.start();
        RiotReader.parseTriples((InputStream)input, (Lang)Lang.NTRIPLES, null, dest);
        dest.finish();
    }

    private static void loadQuads$(Destination<Quad> dest, List<String> urls) {
        dest.start();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + Utils.nowAsString());
            RiotReader.parseQuads((String)url, dest);
        }
        dest.finish();
    }

    private static void loadQuads$(Destination<Quad> dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + Utils.nowAsString());
        dest.start();
        RiotReader.parseQuads((InputStream)input, (Lang)Lang.NQUADS, null, dest);
        dest.finish();
    }

    private static Destination<Triple> destinationNamedGraph(DatasetGraphTDB dsg, Node graphName, boolean showProgress) {
        if (graphName == null) {
            return BulkLoader.destinationDefaultGraph(dsg, showProgress);
        }
        NodeTupleTable ntt = dsg.getQuadTable().getNodeTupleTable();
        NodeTupleTableView ntt2 = new NodeTupleTableView(ntt, graphName);
        return BulkLoader.destination(dsg, ntt2, showProgress);
    }

    public static LoadMonitor createLoadMonitor(DatasetGraphTDB dsg, String itemName, boolean showProgress) {
        if (showProgress) {
            return new LoadMonitor((DatasetGraph)dsg, loadLogger, itemName, DataTickPoint, IndexTickPoint);
        }
        return new LoadMonitor((DatasetGraph)dsg, null, itemName, DataTickPoint, IndexTickPoint);
    }

    private static Destination<Triple> destination(final DatasetGraphTDB dsg, NodeTupleTable nodeTupleTable, boolean showProgress) {
        LoadMonitor monitor = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
        final LoaderNodeTupleTable loaderTriples = new LoaderNodeTupleTable(nodeTupleTable, "triples", monitor);
        Destination<Triple> sink = new Destination<Triple>(){
            long count = 0L;
            private StatsCollector stats;
            private boolean startedEmpty = dsg.isEmpty();

            @Override
            public final void start() {
                loaderTriples.loadStart();
                loaderTriples.loadDataStart();
                this.stats = new StatsCollector();
            }

            public final void send(Triple triple) {
                Node s = triple.getSubject();
                Node p = triple.getPredicate();
                Node o = triple.getObject();
                loaderTriples.load(s, p, o);
                this.stats.record(null, s, p, o);
                ++this.count;
            }

            public final void flush() {
            }

            public void close() {
            }

            @Override
            public final void finish() {
                loaderTriples.loadDataFinish();
                loaderTriples.loadIndexStart();
                loaderTriples.loadIndexFinish();
                loaderTriples.loadFinish();
                if (!dsg.getLocation().isMem() && this.startedEmpty) {
                    String filename = dsg.getLocation().getPath("stats.opt");
                    Stats.write(filename, this.stats);
                }
                BulkLoader.forceSync(dsg);
            }
        };
        return sink;
    }

    private static Destination<Quad> destinationDataset(final DatasetGraphTDB dsg, boolean showProgress) {
        LoadMonitor monitor1 = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
        LoadMonitor monitor2 = BulkLoader.createLoadMonitor(dsg, "quads", showProgress);
        final LoaderNodeTupleTable loaderTriples = new LoaderNodeTupleTable(dsg.getTripleTable().getNodeTupleTable(), "triples", monitor1);
        final LoaderNodeTupleTable loaderQuads = new LoaderNodeTupleTable(dsg.getQuadTable().getNodeTupleTable(), "quads", monitor2);
        Destination<Quad> sink = new Destination<Quad>(){
            long count = 0L;
            private StatsCollector stats;
            private boolean startedEmpty = dsg.isEmpty();

            @Override
            public final void start() {
                loaderTriples.loadStart();
                loaderQuads.loadStart();
                loaderTriples.loadDataStart();
                loaderQuads.loadDataStart();
                this.stats = new StatsCollector();
            }

            public final void send(Quad quad) {
                Node s = quad.getSubject();
                Node p = quad.getPredicate();
                Node o = quad.getObject();
                Node g = null;
                if (!quad.isTriple() && !quad.isDefaultGraph()) {
                    g = quad.getGraph();
                }
                if (g == null) {
                    loaderTriples.load(s, p, o);
                } else {
                    loaderQuads.load(g, s, p, o);
                }
                ++this.count;
                this.stats.record(g, s, p, o);
            }

            @Override
            public final void finish() {
                loaderTriples.loadDataFinish();
                loaderQuads.loadDataFinish();
                loaderTriples.loadIndexStart();
                loaderQuads.loadIndexStart();
                loaderTriples.loadIndexFinish();
                loaderQuads.loadIndexFinish();
                loaderTriples.loadFinish();
                loaderQuads.loadFinish();
                if (!dsg.getLocation().isMem() && this.startedEmpty) {
                    String filename = dsg.getLocation().getPath("stats.opt");
                    Stats.write(filename, this.stats);
                }
                BulkLoader.forceSync(dsg);
            }

            public final void flush() {
            }

            public final void close() {
            }
        };
        return sink;
    }

    static void forceSync(DatasetGraphTDB dsg) {
        dsg.getTripleTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getQuadTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getQuadTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getPrefixes().getNodeTupleTable().getNodeTable().sync();
        dsg.sync();
    }
}

