/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableCache;
import com.hp.hpl.jena.tdb.nodetable.NodeTableFactory;
import com.hp.hpl.jena.tdb.nodetable.NodeTableInline;
import com.hp.hpl.jena.tdb.nodetable.NodeTableNative;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.SystemParams;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public class SetupTDB {
    static final Logger log = TDB.logInfo;
    private static SystemParams params = SystemParams.getStdSystemParams();

    public static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    public static DatasetGraphTDB buildDataset(Location location) {
        return DatasetBuilderStd.build(location);
    }

    public static TripleTable makeTripleTable(Location location, NodeTable nodeTable, String dftPrimary, String[] dftIndexes, DatasetControl policy) {
        String primary = "SPO";
        String[] indexes = Names.tripleIndexes;
        if (indexes.length != 3) {
            SetupTDB.error(log, "Wrong number of triple table indexes: " + StrUtils.strjoin((String)",", (String[])indexes));
        }
        log.debug("Triple table: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        TupleIndex[] tripleIndexes = SetupTDB.makeTupleIndexes(location, primary, indexes, indexes);
        if (tripleIndexes.length != indexes.length) {
            SetupTDB.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable, policy);
        return tripleTable;
    }

    public static QuadTable makeQuadTable(Location location, NodeTable nodeTable, String dftPrimary, String[] dftIndexes, DatasetControl policy) {
        String primary = "GSPO";
        String[] indexes = Names.quadIndexes;
        if (indexes.length != 6) {
            SetupTDB.error(log, "Wrong number of quad table indexes: " + StrUtils.strjoin((String)",", (String[])indexes));
        }
        log.debug("Quad table: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        TupleIndex[] quadIndexes = SetupTDB.makeTupleIndexes(location, primary, indexes, indexes);
        if (quadIndexes.length != indexes.length) {
            SetupTDB.error(log, "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable, policy);
        return quadTable;
    }

    public static DatasetPrefixesTDB makePrefixes(Location location, DatasetControl policy) {
        String indexPrefixes = SetupTDB.params.indexPrefix;
        String primary = SetupTDB.params.primaryIndexPrefix;
        String[] indexes = SetupTDB.params.prefixIndexes;
        TupleIndex[] prefixIndexes = SetupTDB.makeTupleIndexes(location, primary, indexes, new String[]{indexPrefixes});
        if (prefixIndexes.length != indexes.length) {
            SetupTDB.error(log, "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        String pnNode2Id = SetupTDB.params.prefixNode2Id;
        String pnId2Node = SetupTDB.params.prefixId2Node;
        NodeTable prefixNodes = SetupTDB.makeNodeTable(location, pnNode2Id, -1, pnId2Node, -1, -1);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixIndexes, prefixNodes, policy);
        log.debug("Prefixes: " + StrUtils.strjoin((String)", ", (String[])indexes));
        return prefixes;
    }

    public static TupleIndex[] makeTupleIndexes(Location location, String primary, String[] descs, String[] filenames) {
        if (primary.length() != 3 && primary.length() != 4) {
            SetupTDB.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[descs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = SetupTDB.makeTupleIndex(location, primary, descs[i], filenames[i], indexRecordLen);
        }
        return indexes;
    }

    public static TupleIndex makeTupleIndex(Location location, String primary, String indexOrder, String indexName, int keyLength) {
        FileSet fs = new FileSet(location, indexName);
        int readCacheSize = SetupTDB.params.readCacheSize;
        int writeCacheSize = SetupTDB.params.writeCacheSize;
        RangeIndex rIndex = SetupTDB.makeRangeIndex(location, indexName, keyLength, 0, readCacheSize, writeCacheSize);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(primary.length(), new ColumnMap(primary, indexOrder), indexOrder, rIndex.getRecordFactory(), rIndex);
        return tupleIndex;
    }

    public static Index makeIndex(Location location, String indexName, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        return SetupTDB.makeRangeIndex(location, indexName, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
    }

    public static RangeIndex makeRangeIndex(Location location, String indexName, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        FileSet fs = new FileSet(location, indexName);
        RangeIndex rIndex = SetupTDB.makeBPlusTree(fs, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
        return rIndex;
    }

    public static RangeIndex makeBPlusTree(FileSet fs, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        RecordFactory recordFactory = SetupTDB.makeRecordFactory(dftKeyLength, dftValueLength);
        int blkSize = SetupTDB.params.blockSize;
        int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
        BPlusTree rIndex = SetupTDB.createBPTree(fs, order, blkSize, readCacheSize, writeCacheSize, recordFactory);
        return rIndex;
    }

    public static RecordFactory makeRecordFactory(int keyLen, int valueLen) {
        return new RecordFactory(keyLen, valueLen);
    }

    public static NodeTable makeNodeTableBase(Location location, String indexNode2Id, String indexId2Node) {
        if (location.isMem()) {
            return NodeTableFactory.createMem(IndexBuilder.mem());
        }
        FileSet fsIdToNode = new FileSet(location, indexId2Node);
        ObjectFile stringFile = SetupTDB.makeObjectFile(fsIdToNode);
        Index nodeToId = SetupTDB.makeIndex(location, indexNode2Id, 16, 8, -1, -1);
        NodeTableNative nodeTable = new NodeTableNative(nodeToId, stringFile);
        return nodeTable;
    }

    public static NodeTable makeNodeTable(Location location) {
        return SetupTDB.makeNodeTable(location, "node2id", SystemTDB.Node2NodeIdCacheSize, "nodes", SystemTDB.NodeId2NodeCacheSize, 100);
    }

    public static NodeTable makeNodeTable(Location location, String indexNode2Id, int nodeToIdCacheSize, String indexId2Node, int idToNodeCacheSize, int nodeMissCacheSize) {
        NodeTable nodeTable = SetupTDB.makeNodeTableBase(location, indexNode2Id, indexId2Node);
        nodeTable = NodeTableCache.create(nodeTable, nodeToIdCacheSize, idToNodeCacheSize, nodeMissCacheSize);
        nodeTable = NodeTableInline.create(nodeTable);
        return nodeTable;
    }

    public static ObjectFile makeObjectFile(FileSet fsIdToNode) {
        String filename = fsIdToNode.filename("dat");
        ObjectFile objFile = FileFactory.createObjectFileDisk(filename);
        return objFile;
    }

    public static RangeIndex createBPTree(FileSet fileset, RecordFactory factory) {
        int readCacheSize = SystemTDB.BlockReadCacheSize;
        int writeCacheSize = SystemTDB.BlockWriteCacheSize;
        int blockSize = 8192;
        if (fileset.isMem()) {
            readCacheSize = 0;
            writeCacheSize = 0;
            blockSize = 1024;
        }
        return SetupTDB.createBPTreeByBlockSize(fileset, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByBlockSize(FileSet fileset, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupTDB.createBPTree(fileset, -1, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByOrder(FileSet fileset, int order, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupTDB.createBPTree(fileset, order, -1, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTree(FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        int order2;
        if (blockSize < 0 && order < 0) {
            throw new IllegalArgumentException("Neither blocksize nor order specified");
        }
        if (blockSize >= 0 && order < 0) {
            order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
        }
        if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
            throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
        }
        if (blockSize < 0 && order >= 0) {
            blockSize = BPlusTreeParams.calcBlockSize(order, factory);
        }
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(fileset, "idn", blockSize, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(fileset, "dat", blockSize, readCacheSize, writeCacheSize);
        return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
    }
}

