import java.util.GregorianCalendar;

import rs.fon.rs.movies.domain.Actor;
import rs.fon.rs.movies.domain.Movie;
import rs.fon.rs.movies.persistance.RDFModel;
import rs.fon.rs.movies.util.URIGenerator;

public class Main {
	
	public static void main(String[] args) {
		GregorianCalendar a1Birth = new GregorianCalendar();
		a1Birth.set(1946, 6, 6);
		
		Actor a1 = new Actor();
		a1.setName("Sylvester Stallone");
		a1.setDateOfBirth(a1Birth);
		a1.setUri(URIGenerator.generateUri(a1));
		
		RDFModel.getInstance().save(a1);
		
		GregorianCalendar a2Birth = new GregorianCalendar();
		a2Birth.set(1926, 10, 30);
		
		Actor a2 = new Actor();
		a2.setName("Richard Crenna");
		a2.setDateOfBirth(a2Birth);
		a2.setUri(URIGenerator.generateUri(a2));
		
		RDFModel.getInstance().save(a2);
		
		GregorianCalendar m1ReleaseDate = new GregorianCalendar();
		m1ReleaseDate.set(1982, 0, 1);
		
		Movie m1 = new Movie();
		m1.setUri(URIGenerator.generateUri(m1));
		m1.setTitle("Rambo");
		m1.setReleaseDate(m1ReleaseDate);
		m1.addActor(a1);
		m1.addActor(a2);
		
		RDFModel.getInstance().save(m1);
		RDFModel.getInstance().printOut();
		
		Movie m1Copy = (Movie) RDFModel.getInstance().load(m1.getUri().toString());
		
		System.out.println("Loaded movie:");
		System.out.println(m1Copy);
	}
}