package rs.fon.rs.movies.domain;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

import rs.fon.rs.movies.util.Constants;
import thewebsemantic.Namespace;
import thewebsemantic.RdfProperty;
import thewebsemantic.RdfType;

@Namespace(Constants.NS)
@RdfType("Movie")
public class Movie extends Thing {

	@RdfProperty(Constants.DC + "title")
	private String title;
	
	@RdfProperty(Constants.NS + "releaseDate")
	private Calendar releaseDate;
	
	@RdfProperty(Constants.NS + "hasActor")
	private Collection<Actor> actors;
	
	public Movie() {
		actors = new ArrayList<Actor>();
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Calendar getReleaseDate() {
		return releaseDate;
	}

	public void setReleaseDate(Calendar releaseDate) {
		this.releaseDate = releaseDate;
	}

	public Collection<Actor> getActors() {
		return actors;
	}

	public void setActors(Collection<Actor> actors) {
		this.actors = actors;
	}
	
	public void addActor(Actor actor) {
		if (actor != null && !actors.contains(actor)) {
			this.actors.add(actor);
		}
	}

	@Override
	public String toString() {
		return "Movie [title=" + title + ", releaseDate=" + releaseDate
				+ ", actors=" + actors + "]";
	}
	
}
