package rs.fon.rs.movies.persistance;

import rs.fon.rs.movies.util.Constants;
import thewebsemantic.Bean2RDF;
import thewebsemantic.RDF2Bean;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;

public class RDFModel {

	private Model graph;
	private Bean2RDF writer;
	private RDF2Bean reader;
	
	private static RDFModel INSTANCE;
	
	private RDFModel (){
		graph = ModelFactory.createDefaultModel();
		graph.setNsPrefix("movie", Constants.NS);
		graph.setNsPrefix("foaf", Constants.FOAF);
		graph.setNsPrefix("xsd", Constants.XSD);
		graph.setNsPrefix("dc", Constants.DC);
		
		writer = new Bean2RDF(graph);
		reader = new RDF2Bean(graph);
	}
	
	public static RDFModel getInstance(){
		if (INSTANCE == null) {
			INSTANCE = new RDFModel();
		}
		
		return INSTANCE;
	}
	
	public void save(Object o) {
		writer.save(o);
	}
	
	
	public Object load(String uri) {
		return reader.load(uri);
	}
	
	public void printOut(){
		graph.write(System.out, "TURTLE");
	}
}