/**
 * This example trains NaiveBayes incrementally on data obtained
 * from the ArffLoader.
 * 
 */
package rs.fon.is.weka.classifier;

import weka.classifiers.Evaluation;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class WekaToPlayInputFromFile {

	private static String fileName = "data/ToPlayOrNotToPlay.arff";

	public static void main(String[] args) throws Exception {

		// load data
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);

		
		// Create the Naive Bayes Classifier
		NaiveBayes bayesClsf = new NaiveBayes();   
		bayesClsf.buildClassifier(data);
		
		// output generated model
		System.out.println(bayesClsf);
		
		
		// Test the model with the original set
		Evaluation eval = new Evaluation(data);
		eval.evaluateModel(bayesClsf, data);
		

		// Print the result as in Weka explorer
		String strSummary = eval.toSummaryString();
		
		System.out.println("=== Evaluation on training set ===");
		System.out.println("=== Summary ===");
		System.out.println(strSummary);
		
		// Get the confusion matrix
		System.out.println(eval.toMatrixString());
	}
}
