/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.gui.CheckBoxList;
import weka.gui.CustomPanelSupplier;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.Messages;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertySheetPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericObjectEditor
implements PropertyEditor,
CustomPanelSupplier {
    protected Object m_Object;
    protected Object m_Backup;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Class m_ClassType;
    protected Hashtable m_ObjectNames;
    protected GOEPanel m_EditorComponent;
    protected boolean m_Enabled = true;
    protected static String PROPERTY_FILE;
    protected static Properties EDITOR_PROPERTIES;
    public static final String GUIEDITORS_PROPERTY_FILE = "weka/gui/GUIEditors.props";
    protected GOETreeNode m_treeNodeOfCurrentObject;
    protected PropertyPanel m_ObjectPropertyPanel;
    protected boolean m_canChangeClassInDialog;
    protected static boolean m_EditorsRegistered;
    protected Capabilities m_CapabilitiesFilter = null;

    public GenericObjectEditor() {
        this(false);
    }

    public GenericObjectEditor(boolean canChangeClassInDialog) {
        this.m_canChangeClassInDialog = canChangeClassInDialog;
    }

    public static void registerEditors() {
        Properties props;
        if (m_EditorsRegistered) {
            return;
        }
        Messages.getInstance();
        System.err.println(Messages.getString("GenericObjectEditor_RegisterEditors_Error_Text"));
        m_EditorsRegistered = true;
        try {
            props = Utils.readProperties(GUIEDITORS_PROPERTY_FILE);
        }
        catch (Exception e) {
            props = new Properties();
            e.printStackTrace();
        }
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            String value = props.getProperty(name, "");
            try {
                Class<?> cls;
                if (name.endsWith("[]")) {
                    Class<?> baseCls = Class.forName(name.substring(0, name.indexOf("[]")));
                    cls = Array.newInstance(baseCls, 1).getClass();
                } else {
                    cls = Class.forName(name);
                }
                PropertyEditorManager.registerEditor(cls, Class.forName(value));
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_RegisterEditors_Exception_Error_Text_First")).append(name);
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("GenericObjectEditor_RegisterEditors_Exception_Error_Text_Second")).append(value);
                Messages.getInstance();
                System.err.println(stringBuilder3.append(Messages.getString("GenericObjectEditor_RegisterEditors_Exception_Error_Text_Third")).append(e).toString());
            }
        }
    }

    public void setCanChangeClassInDialog(boolean value) {
        this.m_canChangeClassInDialog = value;
    }

    public boolean getCanChangeClassInDialog() {
        return this.m_canChangeClassInDialog;
    }

    public Object getBackup() {
        return this.m_Backup;
    }

    protected static String getRootFromClass(String clsname, String separator) {
        if (clsname.indexOf(separator) > -1) {
            return clsname.substring(0, clsname.indexOf(separator));
        }
        return null;
    }

    public static Hashtable sortClassesByRoot(String classes) {
        Vector list;
        String root;
        if (classes == null) {
            return null;
        }
        Hashtable<String, Vector> roots = new Hashtable<String, Vector>();
        HierarchyPropertyParser hpp = new HierarchyPropertyParser();
        String separator = hpp.getSeperator();
        StringTokenizer tok = new StringTokenizer(classes, ", ");
        while (tok.hasMoreElements()) {
            String clsname = tok.nextToken();
            root = GenericObjectEditor.getRootFromClass(clsname, separator);
            if (root == null) continue;
            if (!roots.containsKey(root)) {
                list = new Vector();
                roots.put(root, list);
            } else {
                list = (Vector)roots.get(root);
            }
            list.add(clsname);
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration enm = roots.keys();
        while (enm.hasMoreElements()) {
            root = (String)enm.nextElement();
            list = (Vector)roots.get(root);
            String tmpStr = "";
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    tmpStr = tmpStr + ",";
                }
                tmpStr = tmpStr + (String)list.get(i);
            }
            result.put(root, tmpStr);
        }
        return result;
    }

    protected Hashtable getClassesFromProperties() {
        Hashtable<String, HierarchyPropertyParser> hpps = new Hashtable<String, HierarchyPropertyParser>();
        String className = this.m_ClassType.getName();
        Hashtable typeOptions = GenericObjectEditor.sortClassesByRoot(EDITOR_PROPERTIES.getProperty(className));
        if (typeOptions != null) {
            try {
                Enumeration enm = typeOptions.keys();
                while (enm.hasMoreElements()) {
                    String root = (String)enm.nextElement();
                    String typeOption = (String)typeOptions.get(root);
                    HierarchyPropertyParser hpp = new HierarchyPropertyParser();
                    hpp.build(typeOption, ", ");
                    hpps.put(root, hpp);
                }
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("GenericObjectEditor_GetClassesFromProperties_Exception_Error_Text")).append(typeOptions).toString());
            }
        }
        return hpps;
    }

    protected void updateObjectNames() {
        String className;
        String root;
        HierarchyPropertyParser hpp;
        if (this.m_ObjectNames == null) {
            this.m_ObjectNames = this.getClassesFromProperties();
        }
        if (this.m_Object != null && (hpp = (HierarchyPropertyParser)this.m_ObjectNames.get(root = GenericObjectEditor.getRootFromClass(className = this.m_Object.getClass().getName(), new HierarchyPropertyParser().getSeperator()))) != null && !hpp.contains(className)) {
            hpp.add(className);
        }
    }

    public void setEnabled(boolean newVal) {
        if (newVal != this.m_Enabled) {
            this.m_Enabled = newVal;
        }
    }

    public void setClassType(Class type) {
        this.m_ClassType = type;
        this.m_ObjectNames = this.getClassesFromProperties();
    }

    public void setDefaultValue() {
        if (this.m_ClassType == null) {
            Messages.getInstance();
            System.err.println(Messages.getString("GenericObjectEditor_SetDefaultValue_Error_Text"));
            return;
        }
        Hashtable hpps = this.getClassesFromProperties();
        HierarchyPropertyParser hpp = null;
        Enumeration enm = hpps.elements();
        try {
            while (enm.hasMoreElements()) {
                hpp = (HierarchyPropertyParser)enm.nextElement();
                if (hpp.depth() <= 0) continue;
                hpp.goToRoot();
                while (!hpp.isLeafReached()) {
                    hpp.goToChild(0);
                }
                String defaultValue = hpp.fullValue();
                this.setValue(Class.forName(defaultValue).newInstance());
            }
        }
        catch (Exception ex) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("GenericObjectEditor_SetDefaultValue_Exception_Error_Text")).append(hpp.fullValue()).toString());
            ex.printStackTrace();
        }
    }

    @Override
    public void setValue(Object o) {
        if (this.m_ClassType == null) {
            Messages.getInstance();
            System.err.println(Messages.getString("GenericObjectEditor_SetValue_Error_Text_First"));
            return;
        }
        if (!this.m_ClassType.isAssignableFrom(o.getClass())) {
            Messages.getInstance();
            System.err.println(Messages.getString("GenericObjectEditor_SetValue_Error_Text_Second"));
            return;
        }
        this.setObject(o);
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.repaint();
        }
        this.updateObjectNames();
    }

    protected void setObject(Object c) {
        boolean trueChange = this.getValue() != null ? !c.equals(this.getValue()) : true;
        this.m_Backup = this.m_Object;
        this.m_Object = c;
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.updateChildPropertySheet();
        }
        if (trueChange) {
            this.m_Support.firePropertyChange("", null, null);
        }
    }

    @Override
    public Object getValue() {
        Object result = null;
        try {
            result = GenericObjectEditor.makeCopy(this.m_Object);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.m_Object.getClass().getName() + "()";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.m_Enabled) {
            String rep;
            if (this.m_Object != null) {
                rep = this.m_Object.getClass().getName();
            } else {
                Messages.getInstance();
                rep = Messages.getString("GenericObjectEditor_PaintValue_Rep_Text");
            }
            int dotPos = rep.lastIndexOf(46);
            if (dotPos != -1) {
                rep = rep.substring(dotPos + 1);
            }
            Font originalFont = gfx.getFont();
            gfx.setFont(originalFont.deriveFont(1));
            FontMetrics fm = gfx.getFontMetrics();
            int vpad = box.height - fm.getHeight();
            gfx.drawString(rep, 2, fm.getAscent() + vpad);
            int repwidth = fm.stringWidth(rep);
            gfx.setFont(originalFont);
            if (this.m_Object instanceof OptionHandler) {
                gfx.drawString(" " + Utils.joinOptions(((OptionHandler)this.m_Object).getOptions()), repwidth + 2, fm.getAscent() + vpad);
            }
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_EditorComponent == null) {
            this.m_EditorComponent = new GOEPanel();
        }
        return this.m_EditorComponent;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    @Override
    public JPanel getCustomPanel() {
        final JButton chooseButton = this.createChooseClassButton();
        this.m_ObjectPropertyPanel = new PropertyPanel(this, true);
        JPanel customPanel = new JPanel(){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                chooseButton.setEnabled(enabled);
            }
        };
        customPanel.setLayout(new BorderLayout());
        customPanel.add((Component)chooseButton, "West");
        customPanel.add((Component)this.m_ObjectPropertyPanel, "Center");
        return customPanel;
    }

    protected JButton createChooseClassButton() {
        Messages.getInstance();
        JButton setButton = new JButton(Messages.getString("GenericObjectEditor_CreateChooseClassButton_SetButton_JButton_Text"));
        setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = GenericObjectEditor.this.getChooseClassPopupMenu();
                if (e.getSource() instanceof Component) {
                    Component comp = (Component)e.getSource();
                    popup.show(comp, comp.getX(), comp.getY());
                    popup.pack();
                    popup.repaint();
                }
            }
        });
        return setButton;
    }

    protected String getClassnameFromPath(TreePath path) {
        StringBuffer classname = new StringBuffer();
        int start = 0;
        if (this.m_ObjectNames.size() > 1) {
            start = 1;
        }
        for (int i = start; i < path.getPathCount(); ++i) {
            if (i > start) {
                classname.append(".");
            }
            classname.append((String)((GOETreeNode)path.getPathComponent(i)).getUserObject());
        }
        return classname.toString();
    }

    public JPopupMenu getChooseClassPopupMenu() {
        this.updateObjectNames();
        this.m_treeNodeOfCurrentObject = null;
        final JTree tree = this.createTree(this.m_ObjectNames);
        if (this.m_treeNodeOfCurrentObject != null) {
            tree.setSelectionPath(new TreePath(this.m_treeNodeOfCurrentObject.getPath()));
        }
        tree.getSelectionModel().setSelectionMode(1);
        final JTreePopupMenu popup = new JTreePopupMenu(tree);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                GOETreeNode node = (GOETreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.isLeaf()) {
                    GenericObjectEditor.this.classSelected(GenericObjectEditor.this.getClassnameFromPath(tree.getSelectionPath()));
                    popup.setVisible(false);
                }
            }
        });
        return popup;
    }

    protected JTree createTree(Hashtable hpps) {
        GOETreeNode superRoot;
        if (hpps.size() > 1) {
            Messages.getInstance();
            superRoot = new GOETreeNode(Messages.getString("GenericObjectEditor_CreateTree_GOETreeNode_Text"));
        } else {
            superRoot = null;
        }
        Enumeration enm = hpps.elements();
        while (enm.hasMoreElements()) {
            HierarchyPropertyParser hpp = (HierarchyPropertyParser)enm.nextElement();
            hpp.goToRoot();
            GOETreeNode root = new GOETreeNode(hpp.getValue());
            this.addChildrenToTree(root, hpp);
            if (superRoot == null) {
                superRoot = root;
                continue;
            }
            superRoot.add(root);
        }
        JTree tree = new JTree(superRoot){
            private static final long serialVersionUID = 6991903188102450549L;

            public String getToolTipText(MouseEvent e) {
                DefaultMutableTreeNode node;
                if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                    return null;
                }
                TreePath currPath = this.getPathForLocation(e.getX(), e.getY());
                if (currPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)currPath.getLastPathComponent()).isLeaf()) {
                    return ((GOETreeNode)node).getToolTipText();
                }
                return null;
            }
        };
        tree.setToolTipText("");
        return tree;
    }

    protected void addChildrenToTree(GOETreeNode tree, HierarchyPropertyParser hpp) {
        try {
            for (int i = 0; i < hpp.numChildren(); ++i) {
                hpp.goToChild(i);
                GOETreeNode child = new GOETreeNode(hpp.getValue());
                if (this.m_Object != null && this.m_Object.getClass().getName().equals(hpp.fullValue())) {
                    this.m_treeNodeOfCurrentObject = child;
                }
                tree.add(child);
                if (hpp.isLeafReached()) {
                    String algName = hpp.fullValue();
                    try {
                        Object alg = Class.forName(algName).newInstance();
                        String toolTip = Utils.getGlobalInfo(alg, true);
                        if (toolTip != null) {
                            child.setToolTipText(toolTip);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.addChildrenToTree(child, hpp);
                hpp.goToParent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void classSelected(String className) {
        try {
            if (this.m_Object != null && this.m_Object.getClass().getName().equals(className)) {
                return;
            }
            this.setValue(Class.forName(className).newInstance());
            if (this.m_EditorComponent != null) {
                this.m_EditorComponent.updateChildPropertySheet();
            }
        }
        catch (Exception ex) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_ClassSelected_Exception_JOptionPaneShowMessageDialog_Text_First")).append(className);
            Messages.getInstance();
            String string = stringBuilder2.append(Messages.getString("GenericObjectEditor_ClassSelected_Exception_JOptionPaneShowMessageDialog_Text_Second")).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(null, string, Messages.getString("GenericObjectEditor_ClassSelected_Exception_JOptionPaneShowMessageDialog_Text_Third"), 0);
            ex.printStackTrace();
            try {
                if (this.m_Backup != null) {
                    this.setValue(this.m_Backup);
                } else {
                    this.setDefaultValue();
                }
            }
            catch (Exception e) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void setCapabilitiesFilter(Capabilities value) {
        this.m_CapabilitiesFilter = new Capabilities(null);
        this.m_CapabilitiesFilter.assign(value);
    }

    public Capabilities getCapabilitiesFilter() {
        return this.m_CapabilitiesFilter;
    }

    public void removeCapabilitiesFilter() {
        this.m_CapabilitiesFilter = null;
    }

    public static Object makeCopy(Object source) throws Exception {
        SerializedObject so = new SerializedObject(source);
        Object result = so.getObject();
        return result;
    }

    public static Vector<String> getClassnames(String property) {
        Vector<String> result = new Vector<String>();
        String value = EDITOR_PROPERTIES.getProperty(property, "").replaceAll(" ", "").trim();
        if (value.length() > 0) {
            String[] items = value.split(",");
            for (int i = 0; i < items.length; ++i) {
                result.add(items[i]);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            GenericObjectEditor ce = new GenericObjectEditor(true);
            ce.setClassType(Classifier.class);
            ZeroR initial = new ZeroR();
            if (args.length > 0) {
                ce.setClassType(Class.forName(args[0]));
                if (args.length > 1) {
                    initial = Class.forName(args[1]).newInstance();
                    ce.setValue(initial);
                } else {
                    ce.setDefaultValue();
                }
            } else {
                ce.setValue(initial);
            }
            PropertyDialog pd = new PropertyDialog((Frame)null, (PropertyEditor)ce, 100, 100);
            pd.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PropertyEditor pe = ((PropertyDialog)e.getSource()).getEditor();
                    Object c = pe.getValue();
                    String options = "";
                    if (c instanceof OptionHandler) {
                        options = Utils.joinOptions(((OptionHandler)c).getOptions());
                    }
                    System.out.println(c.getClass().getName() + " " + options);
                    System.exit(0);
                }
            });
            pd.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        block8: {
            PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
            try {
                GenericPropertiesCreator creator = new GenericPropertiesCreator();
                if (creator.useDynamic()) {
                    try {
                        creator.execute(false);
                        EDITOR_PROPERTIES = creator.getOutputProperties();
                    }
                    catch (Exception e) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        String string = stringBuilder.append(Messages.getString("GenericObjectEditor_JOptionPaneShowMessageDialog_Text_First")).append(e.toString()).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(null, string, Messages.getString("GenericObjectEditor_JOptionPaneShowMessageDialog_Text_Second"), 0);
                    }
                    break block8;
                }
                try {
                    EDITOR_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
                    Enumeration<?> keys = EDITOR_PROPERTIES.propertyNames();
                    if (!keys.hasMoreElements()) {
                        Messages.getInstance();
                        throw new Exception(Messages.getString("GenericObjectEditor_Exception_Text"));
                    }
                }
                catch (Exception ex) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_Exception_JOptionPaneShowMessageDialog_Text_First")).append(PROPERTY_FILE);
                    Messages.getInstance();
                    StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("GenericObjectEditor_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(System.getProperties().getProperty("user.home"));
                    Messages.getInstance();
                    String string = stringBuilder3.append(Messages.getString("GenericObjectEditor_Exception_JOptionPaneShowMessageDialog_Text_Third")).toString();
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(null, string, Messages.getString("GenericObjectEditor_Exception_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
                }
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                String string = stringBuilder.append(Messages.getString("GenericObjectEditor_Exception_JOptionPaneShowMessageDialog_Text_Fifth")).append(e.toString()).toString();
                Messages.getInstance();
                JOptionPane.showMessageDialog(null, string, Messages.getString("GenericObjectEditor_Exception_JOptionPaneShowMessageDialog_Text_Sixth"), 0);
            }
        }
    }

    public class GOEPanel
    extends JPanel {
        static final long serialVersionUID = 3656028520876011335L;
        protected PropertySheetPanel m_ChildPropertySheet;
        protected JLabel m_ClassNameLabel;
        protected JButton m_OpenBut;
        protected JButton m_SaveBut;
        protected JButton m_okBut;
        protected JButton m_cancelBut;
        protected JFileChooser m_FileChooser;

        public GOEPanel() {
            GenericObjectEditor.this.m_Backup = this.copyObject(GenericObjectEditor.this.m_Object);
            Messages.getInstance();
            this.m_ClassNameLabel = new JLabel(Messages.getString("GenericObjectEditor_GOEPanel_ClassNameLabel_JLabel_Text"));
            this.m_ClassNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_ChildPropertySheet = new PropertySheetPanel();
            this.m_ChildPropertySheet.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                }
            });
            Messages.getInstance();
            this.m_OpenBut = new JButton(Messages.getString("GenericObjectEditor_OpenBut_JButton_Text"));
            Messages.getInstance();
            this.m_OpenBut.setToolTipText(Messages.getString("GenericObjectEditor_OpenBut_SetToolTipText_Text"));
            this.m_OpenBut.setEnabled(true);
            this.m_OpenBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object object = GOEPanel.this.openObject();
                    if (object != null) {
                        GenericObjectEditor.this.setValue(object);
                        GenericObjectEditor.this.setValue(object);
                    }
                }
            });
            Messages.getInstance();
            this.m_SaveBut = new JButton(Messages.getString("GenericObjectEditor_SaveBut_JButton_Text"));
            Messages.getInstance();
            this.m_SaveBut.setToolTipText(Messages.getString("GenericObjectEditor_SaveBut_SetToolTipText_Text"));
            this.m_SaveBut.setEnabled(true);
            this.m_SaveBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GOEPanel.this.saveObject(GenericObjectEditor.this.m_Object);
                }
            });
            Messages.getInstance();
            this.m_okBut = new JButton(Messages.getString("GenericObjectEditor_OkBut_JButton_Text"));
            this.m_okBut.setEnabled(true);
            this.m_okBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenericObjectEditor.this.m_Backup = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Object);
                    if (GOEPanel.this.getTopLevelAncestor() != null && GOEPanel.this.getTopLevelAncestor() instanceof Window) {
                        Window w = (Window)GOEPanel.this.getTopLevelAncestor();
                        w.dispose();
                    }
                }
            });
            Messages.getInstance();
            this.m_cancelBut = new JButton(Messages.getString("GenericObjectEditor_CancelBut_JButton_Text"));
            this.m_cancelBut.setEnabled(true);
            this.m_cancelBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GenericObjectEditor.this.m_Backup != null) {
                        GenericObjectEditor.this.m_Object = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Backup);
                        GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                        GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                        GenericObjectEditor.this.updateObjectNames();
                        GOEPanel.this.updateChildPropertySheet();
                    }
                    if (GOEPanel.this.getTopLevelAncestor() != null && GOEPanel.this.getTopLevelAncestor() instanceof Window) {
                        Window w = (Window)GOEPanel.this.getTopLevelAncestor();
                        w.dispose();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            if (GenericObjectEditor.this.m_canChangeClassInDialog) {
                JButton chooseButton = GenericObjectEditor.this.createChooseClassButton();
                JPanel top = new JPanel();
                top.setLayout(new BorderLayout());
                top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                top.add((Component)chooseButton, "West");
                top.add((Component)this.m_ClassNameLabel, "Center");
                this.add((Component)top, "North");
            } else {
                this.add((Component)this.m_ClassNameLabel, "North");
            }
            this.add((Component)this.m_ChildPropertySheet, "Center");
            JPanel okcButs = new JPanel();
            okcButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            okcButs.setLayout(new GridLayout(1, 4, 5, 5));
            okcButs.add(this.m_OpenBut);
            okcButs.add(this.m_SaveBut);
            okcButs.add(this.m_okBut);
            okcButs.add(this.m_cancelBut);
            this.add((Component)okcButs, "South");
            if (GenericObjectEditor.this.m_ClassType != null) {
                GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                if (GenericObjectEditor.this.m_Object != null) {
                    GenericObjectEditor.this.updateObjectNames();
                    this.updateChildPropertySheet();
                }
            }
        }

        protected void setCancelButton(boolean flag) {
            if (this.m_cancelBut != null) {
                this.m_cancelBut.setEnabled(flag);
            }
        }

        protected Object openObject() {
            int returnVal;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((returnVal = this.m_FileChooser.showOpenDialog(this)) == 0) {
                File selected = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
                    Object obj = oi.readObject();
                    oi.close();
                    if (!GenericObjectEditor.this.m_ClassType.isAssignableFrom(obj.getClass())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        throw new Exception(stringBuilder.append(Messages.getString("GenericObjectEditor_OpenObject_Exception_Text")).append(GenericObjectEditor.this.m_ClassType.getName()).toString());
                    }
                    return obj;
                }
                catch (Exception ex) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_OpenObject_Exception_JOptionPaneShowMessageDialog_Text")).append(selected.getName());
                    Messages.getInstance();
                    String string = stringBuilder2.append(Messages.getString("GenericObjectEditor_OpenObject_Exception_JOptionPaneShowMessageDialog_Text")).append(ex.getMessage()).toString();
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(this, string, Messages.getString("GenericObjectEditor_OpenObject_Exception_JOptionPaneShowMessageDialog_Text"), 0);
                }
            }
            return null;
        }

        protected void saveObject(Object object) {
            int returnVal;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((returnVal = this.m_FileChooser.showSaveDialog(this)) == 0) {
                File sFile = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                    oo.writeObject(object);
                    oo.close();
                }
                catch (Exception ex) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_SaveObject_Exception_JOptionPaneShowMessageDialog_Text")).append(sFile.getName());
                    Messages.getInstance();
                    String string = stringBuilder2.append(Messages.getString("GenericObjectEditor_SaveObject_Exception_JOptionPaneShowMessageDialog_Text")).append(ex.getMessage()).toString();
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(this, string, Messages.getString("GenericObjectEditor_SaveObject_Exception_JOptionPaneShowMessageDialog_Text"), 0);
                }
            }
        }

        protected void createFileChooser() {
            this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            this.m_FileChooser.setFileSelectionMode(0);
        }

        protected Object copyObject(Object source) {
            Object result = null;
            try {
                result = GenericObjectEditor.makeCopy(source);
                this.setCancelButton(true);
            }
            catch (Exception ex) {
                this.setCancelButton(false);
                Messages.getInstance();
                System.err.println(Messages.getString("GenericObjectEditor_CopyObject_Error_Text"));
                System.err.println(ex);
            }
            return result;
        }

        public void setOkButtonText(String newLabel) {
            this.m_okBut.setText(newLabel);
        }

        public void addOkListener(ActionListener a) {
            this.m_okBut.addActionListener(a);
        }

        public void addCancelListener(ActionListener a) {
            this.m_cancelBut.addActionListener(a);
        }

        public void removeOkListener(ActionListener a) {
            this.m_okBut.removeActionListener(a);
        }

        public void removeCancelListener(ActionListener a) {
            this.m_cancelBut.removeActionListener(a);
        }

        public void updateChildPropertySheet() {
            Messages.getInstance();
            String className = Messages.getString("GenericObjectEditor_UpdateChildPropertySheet_ClassName_Text");
            if (GenericObjectEditor.this.m_Object != null) {
                className = GenericObjectEditor.this.m_Object.getClass().getName();
            }
            this.m_ClassNameLabel.setText(className);
            this.m_ChildPropertySheet.setTarget(GenericObjectEditor.this.m_Object);
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
                ((Window)this.getTopLevelAncestor()).pack();
            }
        }
    }

    public class JTreePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -3404546329655057387L;
        private final JPopupMenu m_Self;
        private final JTree m_tree;
        private final JScrollPane m_scroller;
        private final JButton m_FilterButton;
        private final JButton m_RemoveFilterButton;
        private final JButton m_CloseButton;

        public JTreePopupMenu(JTree tree) {
            Messages.getInstance();
            this.m_FilterButton = new JButton(Messages.getString("GenericObjectEditor_JTreePopupMenu_FilterButton_JButton_Text"));
            Messages.getInstance();
            this.m_RemoveFilterButton = new JButton(Messages.getString("GenericObjectEditor_JTreePopupMenu_RemoveFilterButton_JButton_Text"));
            Messages.getInstance();
            this.m_CloseButton = new JButton(Messages.getString("GenericObjectEditor_JTreePopupMenu_CloseButton_JButton_Text"));
            this.m_Self = this;
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new FlowLayout(2));
            this.add((Component)panel, "South");
            if (ClassDiscovery.hasInterface(CapabilitiesHandler.class, GenericObjectEditor.this.m_ClassType)) {
                this.m_FilterButton.setMnemonic('F');
                this.m_FilterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == JTreePopupMenu.this.m_FilterButton) {
                            CapabilitiesFilterDialog dialog = new CapabilitiesFilterDialog();
                            dialog.setCapabilities(GenericObjectEditor.this.m_CapabilitiesFilter);
                            dialog.setPopup(JTreePopupMenu.this.m_Self);
                            dialog.setVisible(true);
                            GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                            JTreePopupMenu.this.repaint();
                        }
                    }
                });
                panel.add(this.m_FilterButton);
                this.m_RemoveFilterButton.setMnemonic('R');
                this.m_RemoveFilterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == JTreePopupMenu.this.m_RemoveFilterButton) {
                            GenericObjectEditor.this.m_CapabilitiesFilter = null;
                            GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                            JTreePopupMenu.this.repaint();
                        }
                    }
                });
                panel.add(this.m_RemoveFilterButton);
            }
            this.m_CloseButton.setMnemonic('C');
            this.m_CloseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == JTreePopupMenu.this.m_CloseButton) {
                        JTreePopupMenu.this.m_Self.setVisible(false);
                    }
                }
            });
            panel.add(this.m_CloseButton);
            this.m_tree = tree;
            JPanel treeView = new JPanel();
            treeView.setLayout(new BorderLayout());
            treeView.add((Component)this.m_tree, "North");
            treeView.setBackground(this.m_tree.getBackground());
            this.m_scroller = new JScrollPane(treeView);
            this.m_scroller.setPreferredSize(new Dimension(300, 400));
            this.m_scroller.getVerticalScrollBar().setUnitIncrement(20);
            this.add(this.m_scroller);
        }

        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
            Point location = this.getLocationOnScreen();
            Dimension screenSize = this.getToolkit().getScreenSize();
            int maxWidth = (int)(screenSize.getWidth() - location.getX());
            int maxHeight = (int)(screenSize.getHeight() - location.getY());
            Dimension scrollerSize = this.m_scroller.getPreferredSize();
            int height = (int)scrollerSize.getHeight();
            int width = (int)scrollerSize.getWidth();
            if (width > maxWidth) {
                width = maxWidth;
            }
            if (height > maxHeight) {
                height = maxHeight;
            }
            this.m_scroller.setPreferredSize(new Dimension(width, height));
            this.revalidate();
            this.pack();
        }
    }

    public class CapabilitiesFilterDialog
    extends JDialog {
        static final long serialVersionUID = -7845503345689646266L;
        protected JDialog m_Self;
        protected JPopupMenu m_Popup = null;
        protected Capabilities m_Capabilities = new Capabilities(null);
        protected JLabel m_InfoLabel = new JLabel();
        protected CheckBoxList m_List = new CheckBoxList();
        protected JButton m_OkButton;
        protected JButton m_CancelButton;

        public CapabilitiesFilterDialog() {
            Messages.getInstance();
            this.m_OkButton = new JButton(Messages.getString("GenericObjectEditor_CapabilitiesFilterDialog_OkButton_JButton_Text"));
            Messages.getInstance();
            this.m_CancelButton = new JButton(Messages.getString("GenericObjectEditor_CapabilitiesFilterDialog_CancelButton_JButton_Text"));
            this.m_Self = this;
            this.initGUI();
        }

        protected void initGUI() {
            Messages.getInstance();
            this.setTitle(Messages.getString("GenericObjectEditor_InitGUI_SetTitle_Text"));
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)panel, "North");
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_InitGUI_InfoLabel_SetTitle_Text_First")).append(GenericObjectEditor.this.m_ClassType.getName().replaceAll(".*\\.", ""));
            Messages.getInstance();
            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("GenericObjectEditor_InitGUI_InfoLabel_SetTitle_Text_Second")).append("silver");
            Messages.getInstance();
            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("GenericObjectEditor_InitGUI_InfoLabel_SetTitle_Text_Third")).append("silver");
            Messages.getInstance();
            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("GenericObjectEditor_InitGUI_InfoLabel_SetTitle_Text_Fourth")).append("blue");
            Messages.getInstance();
            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("GenericObjectEditor_InitGUI_InfoLabel_SetTitle_Text_Fifth")).append("blue");
            Messages.getInstance();
            this.m_InfoLabel.setText(stringBuilder6.append(Messages.getString("GenericObjectEditor_InitGUI_InfoLabel_SetTitle_Text_Sixth")).toString());
            panel.add((Component)this.m_InfoLabel, "Center");
            this.getContentPane().add((Component)new JScrollPane(this.m_List), "Center");
            CheckBoxList.CheckBoxListModel model = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                model.addElement((Object)cap);
            }
            panel = new JPanel(new FlowLayout(1));
            this.getContentPane().add((Component)panel, "South");
            this.m_OkButton.setMnemonic('O');
            this.m_OkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CapabilitiesFilterDialog.this.updateCapabilities();
                    if (GenericObjectEditor.this.m_CapabilitiesFilter == null) {
                        GenericObjectEditor.this.m_CapabilitiesFilter = new Capabilities(null);
                    }
                    GenericObjectEditor.this.m_CapabilitiesFilter.assign(CapabilitiesFilterDialog.this.m_Capabilities);
                    CapabilitiesFilterDialog.this.m_Self.setVisible(false);
                    CapabilitiesFilterDialog.this.showPopup();
                }
            });
            panel.add(this.m_OkButton);
            this.m_CancelButton.setMnemonic('C');
            this.m_CancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CapabilitiesFilterDialog.this.m_Self.setVisible(false);
                    CapabilitiesFilterDialog.this.showPopup();
                }
            });
            panel.add(this.m_CancelButton);
            this.pack();
        }

        protected void updateList() {
            CheckBoxList.CheckBoxListModel model = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                model.setChecked(model.indexOf((Object)cap), this.m_Capabilities.handles(cap));
            }
        }

        protected void updateCapabilities() {
            CheckBoxList.CheckBoxListModel model = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                if (model.getChecked(model.indexOf((Object)cap))) {
                    this.m_Capabilities.enable(cap);
                    continue;
                }
                this.m_Capabilities.disable(cap);
            }
        }

        public void setCapabilities(Capabilities value) {
            if (value != null) {
                this.m_Capabilities.assign(value);
            } else {
                this.m_Capabilities = new Capabilities(null);
            }
            this.updateList();
        }

        public Capabilities getCapabilities() {
            return this.m_Capabilities;
        }

        public void setPopup(JPopupMenu value) {
            this.m_Popup = value;
        }

        public JPopupMenu getPopup() {
            return this.m_Popup;
        }

        public void showPopup() {
            if (this.getPopup() != null) {
                this.getPopup().setVisible(true);
            }
        }
    }

    public class GOETreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -1707872446682150133L;
        public static final String NO_SUPPORT = "silver";
        public static final String MAYBE_SUPPORT = "blue";
        protected Capabilities m_Capabilities;
        protected String m_toolTipText;

        public GOETreeNode() {
            this.m_Capabilities = null;
        }

        public GOETreeNode(Object userObject) {
            super(userObject);
            this.m_Capabilities = null;
        }

        public GOETreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
            this.m_Capabilities = null;
        }

        public void setToolTipText(String tip) {
            this.m_toolTipText = tip;
        }

        public String getToolTipText() {
            return this.m_toolTipText;
        }

        protected void initCapabilities() {
            if (this.m_Capabilities != null) {
                return;
            }
            if (!this.isLeaf()) {
                return;
            }
            String classname = GenericObjectEditor.this.getClassnameFromPath(new TreePath(this.getPath()));
            try {
                Class<?> cls = Class.forName(classname);
                if (!ClassDiscovery.hasInterface(CapabilitiesHandler.class, cls)) {
                    return;
                }
                Object obj = cls.newInstance();
                this.m_Capabilities = ((CapabilitiesHandler)obj).getCapabilities();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public String toString() {
            String result = super.toString();
            if (GenericObjectEditor.this.m_CapabilitiesFilter != null) {
                this.initCapabilities();
                if (this.m_Capabilities != null) {
                    if (this.m_Capabilities.supportsMaybe(GenericObjectEditor.this.m_CapabilitiesFilter) && !this.m_Capabilities.supports(GenericObjectEditor.this.m_CapabilitiesFilter)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("GenericObjectEditor_GOETreeNode_ToString_Result_Text_First")).append(MAYBE_SUPPORT);
                        Messages.getInstance();
                        StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("GenericObjectEditor_GOETreeNode_ToString_Result_Text_Second")).append(result);
                        Messages.getInstance();
                        result = stringBuilder3.append(Messages.getString("GenericObjectEditor_GOETreeNode_ToString_Result_Text_Third")).toString();
                    } else if (!this.m_Capabilities.supports(GenericObjectEditor.this.m_CapabilitiesFilter)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("GenericObjectEditor_GOETreeNode_ToString_Result_Text_Fourth")).append(NO_SUPPORT);
                        Messages.getInstance();
                        StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("GenericObjectEditor_GOETreeNode_ToString_Result_Text_Fifth")).append(result);
                        Messages.getInstance();
                        result = stringBuilder5.append(Messages.getString("GenericObjectEditor_GOETreeNode_ToString_Result_Text_Sixth")).toString();
                    }
                }
            }
            return result;
        }
    }
}

