package rs.fon.is.weka.classifier;

import java.util.Enumeration;

import weka.attributeSelection.BestFirst;
import weka.attributeSelection.ClassifierSubsetEval;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;

public class AttributeSelectionExample {

	private static String fileName = "data/census90-income.arff";

	public static void main(String[] args) throws Exception {

		// ucitavamo podatke iz fajla
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// kreiramo klasifikator NaiveBayes i podesavamo da primenjuje
		// diskretizaciju
		NaiveBayes naiveBayesClassifier = new NaiveBayes();
		naiveBayesClassifier.setUseSupervisedDiscretization(true);
		
		// kreiramo evaluator koji ce koristiti prethodno kreirani
		// naiveBayesClassifier
		ClassifierSubsetEval evaluator = new ClassifierSubsetEval();
		evaluator.setClassifier(naiveBayesClassifier);
		
		// kreiramo filter tipa AttributeSelection kojem postavljamo
		// evaluator i metodu pretrage
		AttributeSelection attributeSelectionFilter = new AttributeSelection();
		attributeSelectionFilter.setEvaluator(evaluator);
		attributeSelectionFilter.setSearch(new BestFirst());
		attributeSelectionFilter.setInputFormat(data);
		
		// primenjujemo filter i dobijamo nove podatke kao rezultat
		Instances outputTrain = Filter.useFilter(data, attributeSelectionFilter);
		
		// ispisujemo sve atribute novih podataka
		Enumeration<?> enumerateAttributes = outputTrain.enumerateAttributes();
		while (enumerateAttributes.hasMoreElements()) {
			Object object = (Object) enumerateAttributes.nextElement();
			
			System.out.println(object);
		}
	}
}
