package rs.fon.is.weka.classifier;

import weka.clusterers.ClusterEvaluation;
import weka.clusterers.FilteredClusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.unsupervised.attribute.Remove;

public class KMeansClusteringExample {

	private static String fileName = "data/FishersIrisDataset.arff";

	public static void main(String[] args) throws Exception {

		// ucitavamo podatke iz fajla
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		
		// definisemo Remove filter
		Remove removeFilter = new Remove();
		removeFilter.setAttributeIndices("5");
		
		// ukoliko zelimo da primenimo filter direktno nad podacima i dobijemo
		// novi objekat klase Instances sa filterovanim podacima
//		removeFilter.setInputFormat(data);
//		Instances dataWithoutClass = Filter.useFilter(data, removeFilter);
		
		SimpleKMeans kMeansCLusterer = new SimpleKMeans();
		kMeansCLusterer.setNumClusters(3);
		kMeansCLusterer.setDisplayStdDevs(true);
		
		// koristimo FilteredClusterer koji primenjuje dati filter i
		// nakon toga poziva klasterizaciju. Na ovaj nacin filterom 
		// ne uticemo na originalne podatke
		FilteredClusterer filteredClusterer = new FilteredClusterer();
		filteredClusterer.setClusterer(kMeansCLusterer);
		filteredClusterer.setFilter(removeFilter);
		filteredClusterer.buildClusterer(data);
		
		// ispisujemo podatke klasterovanja
		ClusterEvaluation eval = new ClusterEvaluation();
		eval.setClusterer(filteredClusterer);
		eval.evaluateClusterer(data);
		
		System.out.println(eval.clusterResultsToString());
	}
}
