package rs.fon.is.weka.classifier;

import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class DiscretizingDataExample {

	private static String fileName = "data/FishersIrisDataset.arff";

	public static void main(String[] args) throws Exception {

		// ucitavamo podatke iz fajla
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// kreiramo filter koji radi diskretizaciju
		Discretize discretizeFilter = new Discretize();
		discretizeFilter.setAttributeIndices("first-last");
		discretizeFilter.setInputFormat(data);
		discretizeFilter.setBins(10);
		discretizeFilter.setUseEqualFrequency(false);
		
		// primenjujemo filter i dobijamo nove podatke kao rezultat
		Instances outputTrain = Filter.useFilter(data, discretizeFilter);
		
		System.out.println(outputTrain);
	}
}
