package rs.fon.is.weka.classifier;

import weka.clusterers.ClusterEvaluation;
import weka.clusterers.EM;
import weka.clusterers.FilteredClusterer;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.unsupervised.attribute.Remove;

public class EMClusteringExample {

	private static String fileName = "data/FishersIrisDataset.arff";

	public static void main(String[] args) throws Exception {

		// ucitavamo podatke iz fajla
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		
		// definisemo Remove filter
		Remove removeFilter = new Remove();
		removeFilter.setAttributeIndices("5");
		
		// ukoliko zelimo da primenimo filter direktno nad podacima i dobijemo
		// novi objekat klase Instances sa filterovanim podacima
//		removeFilter.setInputFormat(data);
//		Instances dataWithoutClass = Filter.useFilter(data, removeFilter);
		
		EM emClusterer = new EM();
		emClusterer.setNumClusters(3);
		
		// koristimo FilteredClusterer koji primenjuje dati filter i
		// nakon toga poziva klasterizaciju. Na ovaj nacin filterom 
		// ne uticemo na originalne podatke
		FilteredClusterer filteredClusterer = new FilteredClusterer();
		filteredClusterer.setClusterer(emClusterer);
		filteredClusterer.setFilter(removeFilter);
		filteredClusterer.buildClusterer(data);
		
		// ispisujemo podatke klasterovanja
		ClusterEvaluation eval = new ClusterEvaluation();
		eval.setClusterer(filteredClusterer);
		eval.evaluateClusterer(data);
		
		System.out.println(eval.clusterResultsToString());
	}
}
