/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;

public class AggAvg
extends AggregatorBase {
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvg(Expr expr) {
        super("AVG", false, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggAvg(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccAvg(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    @Override
    public int hashCode() {
        return 0x170 ^ this.getExprList().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggAvg)) {
            return false;
        }
        AggAvg a = (AggAvg)other;
        return this.exprList.equals(a.exprList, bySyntax);
    }

    private static class AccAvg
    extends AccumulatorExpr {
        private NodeValue total = AggAvg.access$000();
        private int count = 0;
        static final boolean DEBUG = false;

        public AccAvg(Expr expr) {
            super(expr);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                ++this.count;
                this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("avg: not a number: " + nv);
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            if (this.errorCount != 0L) {
                return null;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.numDivide(this.total, nvCount);
        }
    }
}

