/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.main.iterator.QueryIterGraph;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.solver.QC2;
import org.apache.jena.tdb.solver.SolverLib;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.GraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutorTDB1
extends OpExecutor {
    private static final Logger log = LoggerFactory.getLogger(OpExecutorTDB1.class);
    public static final OpExecutorFactory OpExecFactoryTDB = new OpExecutorFactory(){

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorTDB1(execCxt);
        }
    };
    private final boolean isForTDB;
    private static OpExecutorFactory plainFactory = new OpExecutorPlainFactoryTDB();

    public OpExecutorTDB1(ExecutionContext execCxt) {
        super(execCxt);
        this.isForTDB = execCxt.getActiveGraph() instanceof GraphTDB;
    }

    protected QueryIterator exec(Op op, QueryIterator input) {
        if (this.level < 0) {
            Explain.explain((String)"TDB", (Op)op, (Context)this.execCxt.getContext());
        }
        return super.exec(op, input);
    }

    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opFilter, input);
        }
        if (OpBGP.isBGP((Op)opFilter.getSubOp())) {
            GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
            OpBGP opBGP = (OpBGP)opFilter.getSubOp();
            return OpExecutorTDB1.executeBGP(graph, opBGP, input, opFilter.getExprs(), this.execCxt);
        }
        if (opFilter.getSubOp() instanceof OpQuadPattern) {
            OpQuadPattern quadPattern = (OpQuadPattern)opFilter.getSubOp();
            DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
            return OpExecutorTDB1.optimizeExecuteQuads(ds, input, quadPattern.getGraphNode(), quadPattern.getBasicPattern(), opFilter.getExprs(), this.execCxt);
        }
        return super.execute(opFilter, input);
    }

    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opBGP, input);
        }
        GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
        return OpExecutorTDB1.executeBGP(graph, opBGP, input, null, this.execCxt);
    }

    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(quadPattern, input);
        }
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        BasicPattern bgp = quadPattern.getBasicPattern();
        Node gn = quadPattern.getGraphNode();
        return OpExecutorTDB1.optimizeExecuteQuads(ds, input, gn, bgp, null, this.execCxt);
    }

    protected QueryIterator execute(OpGraph opGraph, QueryIterator input) {
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    private static QueryIterator executeBGP(GraphTDB graph, OpBGP opBGP, QueryIterator input, ExprList exprs, ExecutionContext execCxt) {
        if (!OpExecutorTDB1.isDefaultGraphStorage(graph.getGraphName())) {
            DatasetGraphTDB ds = graph.getDSG();
            return OpExecutorTDB1.optimizeExecuteQuads(ds, input, graph.getGraphName(), opBGP.getPattern(), exprs, execCxt);
        }
        return OpExecutorTDB1.optimizeExecuteTriples(graph, input, opBGP.getPattern(), exprs, execCxt);
    }

    private static QueryIterator optimizeExecuteTriples(GraphTDB graph, QueryIterator input, BasicPattern pattern, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if (pattern.size() >= 2 && (transform = graph.getDSG().getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create((QueryIterator)input, (ExecutionContext)execCxt);
            input = peek;
            pattern = OpExecutorTDB1.reorder(pattern, peek, transform);
        }
        Object op = null;
        op = exprs != null ? TransformFilterPlacement.transform((ExprList)exprs, (BasicPattern)pattern) : new OpBGP(pattern);
        return OpExecutorTDB1.plainExecute(op, input, execCxt);
    }

    private static QueryIterator optimizeExecuteQuads(DatasetGraphTDB ds, QueryIterator input, Node gn, BasicPattern bgp, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if ((gn = OpExecutorTDB1.decideGraphNode(gn, execCxt)) == null) {
            return OpExecutorTDB1.optimizeExecuteTriples(ds.getEffectiveDefaultGraph(), input, bgp, exprs, execCxt);
        }
        if (bgp.size() >= 2 && (transform = ds.getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create((QueryIterator)input, (ExecutionContext)execCxt);
            input = peek;
            bgp = OpExecutorTDB1.reorder(bgp, peek, transform);
        }
        Object op = null;
        op = exprs != null ? TransformFilterPlacement.transform((ExprList)exprs, (Node)gn, (BasicPattern)bgp) : new OpQuadPattern(gn, bgp);
        return OpExecutorTDB1.plainExecute(op, input, execCxt);
    }

    private static QueryIterator plainExecute(Op op, QueryIterator input, ExecutionContext execCxt) {
        ExecutionContext ec2 = new ExecutionContext(execCxt);
        ec2.setExecutor(plainFactory);
        return QC.execute((Op)op, (QueryIterator)input, (ExecutionContext)ec2);
    }

    private static BasicPattern reorder(BasicPattern pattern, QueryIterPeek peek, ReorderTransformation transform) {
        if (transform != null) {
            if (!peek.hasNext()) {
                throw new ARQInternalErrorException("Peek iterator is already empty");
            }
            BasicPattern pattern2 = Substitute.substitute((BasicPattern)pattern, (Binding)peek.peek());
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        return pattern;
    }

    public static Node decideGraphNode(Node gn, ExecutionContext execCxt) {
        if (OpExecutorTDB1.isDefaultGraphStorage(gn)) {
            return null;
        }
        if (Quad.isUnionGraph((Node)gn)) {
            return Node.ANY;
        }
        boolean doingUnion = false;
        return gn;
    }

    private static boolean isDefaultGraphStorage(Node gn) {
        if (gn == null) {
            return true;
        }
        return Quad.isDefaultGraph((Node)gn);
    }

    protected QueryIterator execute(OpDatasetNames dsNames, QueryIterator input) {
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        Predicate<Tuple<NodeId>> filter = QC2.getFilter(this.execCxt.getContext());
        Node gn = dsNames.getGraphNode();
        if (Var.isVar((Node)gn)) {
            return SolverLib.graphNames(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
        }
        return SolverLib.testForGraphName(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
    }

    private static class OpExecutorPlainTDB
    extends OpExecutor {
        Predicate<Tuple<NodeId>> filter = null;

        public OpExecutorPlainTDB(ExecutionContext execCxt) {
            super(execCxt);
            this.filter = QC2.getFilter(execCxt.getContext());
        }

        public QueryIterator execute(OpBGP opBGP, QueryIterator input) {
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opBGP.getPattern();
                Explain.explain((String)"Execute", (BasicPattern)bgp, (Context)this.execCxt.getContext());
                GraphTDB gtdb = (GraphTDB)g;
                Node gn = OpExecutorTDB1.decideGraphNode(gtdb.getGraphName(), this.execCxt);
                return SolverLib.execute(gtdb.getDSG(), gn, bgp, input, this.filter, this.execCxt);
            }
            Log.warn((Object)((Object)this), (String)"Non-GraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opBGP, input);
        }

        public QueryIterator execute(OpQuadPattern opQuadPattern, QueryIterator input) {
            Node gn = opQuadPattern.getGraphNode();
            gn = OpExecutorTDB1.decideGraphNode(gn, this.execCxt);
            if (this.execCxt.getDataset() instanceof DatasetGraphTDB) {
                DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
                Explain.explain((String)"Execute", (QuadPattern)opQuadPattern.getPattern(), (Context)this.execCxt.getContext());
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                return SolverLib.execute(ds, gn, bgp, input, this.filter, this.execCxt);
            }
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                Explain.explain((String)"Execute", (BasicPattern)bgp, (Context)this.execCxt.getContext());
                return SolverLib.execute(((GraphTDB)g).getDSG(), gn, bgp, input, this.filter, this.execCxt);
            }
            Log.warn((Object)((Object)this), (String)"Non-DatasetGraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opQuadPattern, input);
        }
    }

    private static class OpExecutorPlainFactoryTDB
    implements OpExecutorFactory {
        private OpExecutorPlainFactoryTDB() {
        }

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorPlainTDB(execCxt);
        }
    }
}

