package rs.ac.bg.fon.ai.books.main;
import java.util.Collection;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

import rs.ac.bg.fon.ai.books.persistance.RDFModel;
import rs.ac.bg.fon.ai.books.services.BookService;
import rs.ac.bg.fon.ai.books.services.UserService;

public class Main {

	public static void main(String[] args) {
		
		UserService userService = new UserService();
		BookService bookService = new BookService();
		
		Resource person1 = userService.createUser("http://example.com/person1", "Lore Segal");
		Resource person2 = userService.createUser("http://example.com/person2", "Joy Williams");
		Resource person3 = userService.createUser("http://example.com/person3", "John Banville");
		
		Resource book1 = bookService.createBook(
				"http://example.com/book1", 
				"Shakespeare's Kitchen", 
				"Pulitzer Prize",
				person1);
		
		Resource book2 = bookService.createBook(
				"http://example.com/book2", 
				"The Quick and the Dead", 
				"Pulitzer Prize",
				person2);
		
		Resource book3 = bookService.createBook(
				"http://example.com/book3", 
				"The Sea", 
				"Man Booker Prize",
				person3);
		
		System.out.println("Svi dobitnici Pulicer nagrade:");
		
		Collection<String> writerNames = bookService.getAllPulitzerWinners();
		
		if (writerNames != null && !writerNames.isEmpty()) {
			for (String name : writerNames) {
				System.out.println(name);
			}
		}

		
		System.out.println("\n\n--------------------");
		System.out.println("Knjige o Sekspiru:");
		
		Model shakespeareBooks = bookService.describeBooksAboutShakespeare();
		shakespeareBooks.write(System.out, "JSON-LD");
	}
}
