package rs.ac.bg.fon.ai.books.persistance;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

import rs.ac.bg.fon.ai.books.util.Constants;

public class RDFModel {

	private Model model;
	
	private static RDFModel INSTANCE;
	
	private RDFModel (){
		model = ModelFactory.createDefaultModel();
		
		model.setNsPrefix("Person", Constants.SCHEMA + "Person");
		model.setNsPrefix("Book", Constants.SCHEMA + "Book");
		model.setNsPrefix("name", Constants.SCHEMA + "name");
		model.setNsPrefix("award", Constants.SCHEMA + "award");
		model.setNsPrefix("author", Constants.SCHEMA + "author");
	}
	
	public static RDFModel getInstance(){
		if (INSTANCE == null) {
			INSTANCE = new RDFModel();
		}
		return INSTANCE;
	}
	
	public Model getModel() {
		return model;
	}

	public void printOut(){
		model.write(System.out, "JSON-LD");
	}
}