/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.RepeatApplyIterator;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.tdb.solver.BindingNodeId;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;

public class StageMatchTuple
extends RepeatApplyIterator<BindingNodeId> {
    private final NodeTupleTable nodeTupleTable;
    private final Tuple<Node> patternTuple;
    private final ExecutionContext execCxt;
    private boolean anyGraphs;
    private Predicate<Tuple<NodeId>> filter;
    private static Consumer<Tuple<NodeId>> quadsToAnyTriples = item -> {
        ((NodeId[])item.tuple())[0] = NodeId.NodeIdAny;
    };

    public StageMatchTuple(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> tuple, boolean anyGraphs, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        super(input);
        this.filter = filter;
        this.nodeTupleTable = nodeTupleTable;
        this.patternTuple = tuple;
        this.execCxt = execCxt;
        this.anyGraphs = anyGraphs;
    }

    public static void prepare(NodeTable nodeTable, Tuple<Node> patternTuple, BindingNodeId input, NodeId[] ids, Var[] var) {
        for (int i = 0; i < patternTuple.size(); ++i) {
            Node n = (Node)patternTuple.get(i);
            NodeId nId = StageMatchTuple.idFor(nodeTable, input, n);
            if (NodeId.isDoesNotExist(nId)) {
                new NullIterator();
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTuple.asVar(n);
        }
    }

    protected Iterator<BindingNodeId> makeNextStage(BindingNodeId input) {
        Object[] ids = new NodeId[this.patternTuple.size()];
        Var[] var = new Var[this.patternTuple.size()];
        StageMatchTuple.prepare(this.nodeTupleTable.getNodeTable(), this.patternTuple, input, (NodeId[])ids, var);
        Iterator iterMatches = this.nodeTupleTable.find((Tuple<NodeId>)Tuple.create((Object[])ids));
        if (this.filter != null) {
            iterMatches = Iter.filter(iterMatches, this.filter);
        }
        if (this.anyGraphs) {
            iterMatches = Iter.operate((Iterator)iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent((Iterator)iterMatches);
        }
        Function<Tuple, BindingNodeId> binder = tuple -> {
            BindingNodeId output = new BindingNodeId(input);
            for (int i = 0; i < var.length; ++i) {
                Var v = var[i];
                if (v == null) continue;
                NodeId id = (NodeId)tuple.get(i);
                if (StageMatchTuple.reject(output, v, id)) {
                    return null;
                }
                output.put(v, id);
            }
            return output;
        };
        return Iter.iter((Iterator)iterMatches).map(binder).removeNulls();
    }

    private static Iterator<Tuple<NodeId>> print(Iterator<Tuple<NodeId>> iter) {
        if (!iter.hasNext()) {
            System.err.println("<empty>");
        } else {
            List r = Iter.toList(iter);
            String str = Iter.asString((Iterable)r, (String)"\n");
            System.err.println(str);
            iter = Iter.iter((Collection)r);
        }
        return iter;
    }

    private static boolean reject(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return false;
        }
        return !((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar((Node)node)) {
            return Var.alloc((Node)node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar((Node)node)) {
            NodeId n = (NodeId)input.get(Var.alloc((Node)node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

