/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public abstract class WriterStreamRDFBase
implements StreamRDF {
    protected boolean activeTripleData = false;
    protected boolean activeQuadData = false;
    protected boolean lastWasDirective = false;
    protected final PrefixMap pMap;
    protected String baseURI = null;
    protected final NodeToLabel nodeToLabel;
    protected NodeFormatterTTL fmt;
    protected final IndentedWriter out;

    public WriterStreamRDFBase(OutputStream output) {
        this(new IndentedWriter(output));
    }

    public WriterStreamRDFBase(IndentedWriter output) {
        this.out = output;
        this.baseURI = null;
        this.pMap = PrefixMapFactory.create();
        this.nodeToLabel = NodeToLabel.createScopeByDocument();
        this.setFormatter();
    }

    private void setFormatter() {
        this.fmt = new NodeFormatterTTL(this.baseURI, this.pMap, this.nodeToLabel);
    }

    public WriterStreamRDFBase(Writer output) {
        this(WriterStreamRDFBase.wrap(output));
    }

    private static IndentedWriter wrap(Writer output) {
        if (!(output instanceof BufferedWriter)) {
            output = new BufferedWriter(output, 32768);
        }
        return RiotLib.create(output);
    }

    private void reset$() {
        this.activeTripleData = false;
        this.activeQuadData = false;
        this.lastWasDirective = false;
    }

    @Override
    public final void start() {
        this.reset$();
        this.startData();
    }

    @Override
    public final void finish() {
        this.endData();
        this.out.flush();
    }

    @Override
    public final void triple(Triple triple) {
        this.print(triple);
        this.activeTripleData = true;
    }

    @Override
    public final void quad(Quad quad) {
        this.print(quad);
        this.activeQuadData = true;
    }

    @Override
    public final void base(String base) {
        this.baseURI = base;
        this.setFormatter();
    }

    @Override
    public final void prefix(String prefix, String iri2) {
        this.endData();
        this.lastWasDirective = true;
        this.out.print("@prefix ");
        this.out.print(prefix);
        this.out.print(":  <");
        this.out.print(iri2);
        this.out.println("> .");
        this.pMap.add(prefix, iri2);
    }

    protected void outputNode(Node n) {
        this.fmt.format((AWriter)this.out, n);
    }

    protected abstract void startData();

    protected abstract void endData();

    protected abstract void print(Quad var1);

    protected abstract void print(Triple var1);

    protected abstract void reset();

    protected void DEBUG(String fmt, Object ... args) {
        int loc = this.out.getCol();
        int off = this.out.getAbsoluteIndent();
        this.out.ensureStartOfLine();
        this.out.setAbsoluteIndent(0);
        this.out.println(String.format(fmt, args));
        this.out.setAbsoluteIndent(off);
        this.out.ensureStartOfLine();
        this.out.pad(loc, true);
    }
}

