/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;

public class AggSample
extends AggregatorBase {
    public AggSample(Expr expr) {
        super("SAMPLE", false, expr);
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggSample(exprs.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccSample(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return null;
    }

    @Override
    public int hashCode() {
        return 0x17A ^ this.getExpr().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSample)) {
            return false;
        }
        AggSample agg = (AggSample)other;
        return this.exprList.equals(agg.exprList, bySyntax);
    }

    private static class AccSample
    extends AccumulatorExpr {
        private NodeValue sampleSoFar = null;

        public AccSample(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.sampleSoFar == null) {
                this.sampleSoFar = nv;
                return;
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.sampleSoFar;
        }
    }
}

