/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.journaling;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.jena.ext.com.google.common.collect.Lists;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWithLock;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.journaling.ListBackedOperationRecord;
import org.apache.jena.sparql.core.journaling.QuadOperation;
import org.apache.jena.sparql.core.journaling.ReversibleOperationRecord;
import org.apache.jena.sparql.graph.GraphFactory;

public class DatasetGraphWithRecord
extends DatasetGraphWithLock {
    private ReversibleOperationRecord<QuadOperation<?, ?>> record = new ListBackedOperationRecord(new ArrayList());
    private final Lock recordLock = new ReentrantLock(true);
    private boolean recording = false;
    private final Consumer<Node> _removeGraph = graphName -> {
        this.deleteAny((Node)graphName, Node.ANY, Node.ANY, Node.ANY);
        super.removeGraph((Node)graphName);
    };
    private final Consumer<Quad> _add = quad -> {
        if (!this.contains((Quad)quad)) {
            super.add((Quad)quad);
            if (this.isRecording()) {
                this.record.accept(new QuadOperation.QuadAddition((Quad)quad));
            }
        }
    };
    private final Consumer<Quad> _delete = quad -> {
        if (this.contains((Quad)quad)) {
            super.delete((Quad)quad);
            if (this.isRecording()) {
                this.record.accept(new QuadOperation.QuadDeletion((Quad)quad));
            }
        }
    };

    private boolean isRecording() {
        return this.recording;
    }

    private void startRecording() {
        this.recordLock.lock();
        this.recording = true;
    }

    private void stopRecording() {
        this.recording = false;
    }

    public DatasetGraphWithRecord(DatasetGraph dsg) {
        super(dsg);
    }

    public DatasetGraphWithRecord(DatasetGraph dsg, ReversibleOperationRecord<QuadOperation<?, ?>> record) {
        super(dsg);
        this.record = record;
    }

    private <T> void mutate(T data, Consumer<T> mutator) {
        if (!this.allowedToWrite()) {
            throw new JenaTransactionException("Tried to write in a non-WRITE transaction!");
        }
        mutator.accept(data);
    }

    @Override
    public void add(Quad quad) {
        this.mutate(quad, this._add);
    }

    @Override
    public void delete(Quad quad) {
        this.mutate(quad, this._delete);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.mutate(graph, this._addGraph(graphName));
    }

    @Override
    public void removeGraph(Node graphName) {
        this.mutate(graphName, this._removeGraph);
    }

    private Consumer<Graph> _addGraph(Node name) {
        return g -> {
            super.addGraph(name, GraphFactory.createGraphMem());
            g.find(Node.ANY, Node.ANY, Node.ANY).forEachRemaining(t -> this.add(new Quad(name, (Triple)t)));
        };
    }

    private boolean allowedToWrite() {
        return !this.isInTransaction() || this.isInTransaction() && this.isTransactionType(ReadWrite.WRITE);
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.add(new Quad(g, s, p, o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(new Quad(g, s, p, o));
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        Lists.newArrayList(this.find(g, s, p, o)).forEach(this::delete);
    }

    @Override
    public void clear() {
        this.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        super.clear();
    }

    @Override
    protected boolean abortImplemented() {
        return true;
    }

    @Override
    protected void _begin(ReadWrite readWrite) {
        super._begin(readWrite);
        if (readWrite.equals((Object)ReadWrite.WRITE)) {
            this.startRecording();
        }
    }

    @Override
    protected void _commit() {
        this.stopRecording();
        this.record.clear();
        this.recordLock.unlock();
        super._commit();
    }

    @Override
    protected void _abort() {
        this._end();
    }

    @Override
    protected void _end() {
        if (this.isRecording()) {
            try {
                this.stopRecording();
                this.record.reverse().consume(op -> ((QuadOperation)op.inverse()).actOn(this));
            }
            finally {
                this.recordLock.unlock();
            }
        }
        super._end();
    }

    @Override
    public void close() {
        if (this.isRecording()) {
            this.stopRecording();
            this.record.clear();
            this.recordLock.unlock();
        }
        super.close();
    }
}

