/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.stream.Stream;
import org.apache.jena.atlas.lib.persistent.PersistentSet;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.mem.FourTupleMap;
import org.apache.jena.sparql.core.mem.PMapTupleTable;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PMapTripleTable
extends PMapTupleTable<FourTupleMap.ThreeTupleMap, Triple>
implements TripleTable {
    private static final Logger log = LoggerFactory.getLogger(PMapTripleTable.class);

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected FourTupleMap.ThreeTupleMap initial() {
        return new FourTupleMap.ThreeTupleMap();
    }

    public PMapTripleTable(String tableName) {
        super(tableName);
    }

    public Stream<Triple> _find(Node first, Node second, Node third) {
        this.debug("Querying on three-tuple pattern: {} {} {} .", first, second, third);
        FourTupleMap.ThreeTupleMap threeTuples = (FourTupleMap.ThreeTupleMap)((Object)this.local().get());
        if (this.isConcrete(first)) {
            this.debug("Using a specific first slot value.", new Object[0]);
            return threeTuples.get(first).map(twoTuples -> {
                if (this.isConcrete(second)) {
                    this.debug("Using a specific second slot value.", new Object[0]);
                    return twoTuples.get(second).map(oneTuples -> {
                        if (this.isConcrete(third)) {
                            this.debug("Using a specific third slot value.", new Object[0]);
                            return oneTuples.contains((Object)third) ? Stream.of(this.triple(first, second, third)) : Stream.empty();
                        }
                        this.debug("Using a wildcard third slot value.", new Object[0]);
                        return oneTuples.stream().map(slot3 -> this.triple(first, second, (Node)slot3));
                    }).orElse(Stream.empty());
                }
                this.debug("Using wildcard second and third slot values.", new Object[0]);
                return twoTuples.flatten((slot2, oneTuples) -> oneTuples.stream().map(slot3 -> this.triple(first, (Node)slot2, (Node)slot3)));
            }).orElse(Stream.empty());
        }
        this.debug("Using a wildcard for all slot values.", new Object[0]);
        return threeTuples.flatten((slot1, twoTuples) -> twoTuples.flatten((slot2, oneTuples) -> oneTuples.stream().map(slot3 -> this.triple((Node)slot1, (Node)slot2, (Node)slot3))));
    }

    protected abstract Triple triple(Node var1, Node var2, Node var3);

    protected void _add(Node first, Node second, Node third) {
        this.debug("Adding three-tuple {} {} {}", first, second, third);
        FourTupleMap.ThreeTupleMap threeTuples = (FourTupleMap.ThreeTupleMap)((Object)this.local().get());
        FourTupleMap.TwoTupleMap twoTuples = threeTuples.get(first).orElse(new FourTupleMap.TwoTupleMap());
        PersistentSet oneTuples = twoTuples.get(second).orElse(PersistentSet.empty());
        oneTuples = oneTuples.plus((Object)third);
        twoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(second)).plus(second, oneTuples);
        this.local().set(((FourTupleMap.ThreeTupleMap)threeTuples.minus(first)).plus(first, (Object)twoTuples));
    }

    protected void _delete(Node first, Node second, Node third) {
        this.debug("Deleting three-tuple {} {} {}", first, second, third);
        FourTupleMap.ThreeTupleMap threeTuples = (FourTupleMap.ThreeTupleMap)((Object)this.local().get());
        threeTuples.get(first).ifPresent(twoTuples -> twoTuples.get(second).ifPresent(oneTuples -> {
            if (oneTuples.contains((Object)third)) {
                FourTupleMap.TwoTupleMap newTwoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(second)).plus(second, oneTuples.minus((Object)third));
                this.debug("Setting transactional index to new value.", new Object[0]);
                this.local().set(((FourTupleMap.ThreeTupleMap)threeTuples.minus(first)).plus(first, (Object)newTwoTuples));
            }
        }));
    }
}

