/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineFactoryWrapper;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.util.Context;

public class QueryEngineRegistry {
    List<QueryEngineFactory> factories = new ArrayList<QueryEngineFactory>();
    static QueryEngineRegistry registry;

    public static QueryEngineRegistry get() {
        if (registry == null) {
            QueryEngineRegistry.init();
        }
        return registry;
    }

    private QueryEngineRegistry() {
    }

    private static synchronized void init() {
        registry = new QueryEngineRegistry();
        registry.add(QueryEngineMain.getFactory());
        registry.add(QueryEngineFactoryWrapper.get());
    }

    public static QueryEngineFactory findFactory(Query query2, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(query2, dataset, context);
    }

    public static QueryEngineFactory findFactory(Op op, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(op, dataset, context);
    }

    public QueryEngineFactory find(Query query2, DatasetGraph dataset) {
        return this.find(query2, dataset, null);
    }

    public QueryEngineFactory find(Query query2, DatasetGraph dataset, Context context) {
        for (QueryEngineFactory f : this.factories) {
            if (!f.accept(query2, dataset, context)) continue;
            return f;
        }
        return null;
    }

    public QueryEngineFactory find(Op op, DatasetGraph dataset, Context context) {
        for (QueryEngineFactory f : this.factories) {
            if (!f.accept(op, dataset, context)) continue;
            return f;
        }
        return null;
    }

    public static void addFactory(QueryEngineFactory f) {
        QueryEngineRegistry.get().add(f);
    }

    public void add(QueryEngineFactory f) {
        this.factories.add(0, f);
    }

    public static void removeFactory(QueryEngineFactory f) {
        QueryEngineRegistry.get().remove(f);
    }

    public void remove(QueryEngineFactory f) {
        this.factories.remove(f);
    }

    public List<QueryEngineFactory> factories() {
        return this.factories;
    }

    public static boolean containsFactory(QueryEngineFactory f) {
        return QueryEngineRegistry.get().contains(f);
    }

    public boolean contains(QueryEngineFactory f) {
        return this.factories.contains(f);
    }

    static {
        QueryEngineRegistry.init();
        registry = null;
    }
}

