package rs.ac.bg.fon.ai.inteligentniSistemi.rdf;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class Main {

	public static void main(String[] args) {

		String directorIri = "http://www.imdb.com/name/nm0634240/";
		String directorName = "Christopher Nolan";
		String movieIri = "http://www.imdb.com/title/tt0816692/";
		String movieName = "Interstellar";
		
		//creating empty model (graph)
		Model graph = ModelFactory.createDefaultModel();
		graph.setNsPrefix("Person", "http://schema.org/Person");
		graph.setNsPrefix("Movie", "http://schema.org/Movie");
		graph.setNsPrefix("name", "http://schema.org/name");
		graph.setNsPrefix("name", "http://schema.org/name");
		graph.setNsPrefix("datePublished", "http://schema.org/datePublished");
		graph.setNsPrefix("director", "http://schema.org/director");
		
		// declaring properties
		Property nameProp = graph.createProperty("http://schema.org/name");
		Property datePublishedProp = graph.createProperty("http://schema.org/datePublished");
		Property directorProp = graph.createProperty("http://schema.org/director");
		
		// creating classes
		Resource personClass = graph.createResource("http://schema.org/Person");
		Resource movieClass = graph.createResource("http://schema.org/Movie");
		
		// create the director instance
		Resource christopherNolanPerson = graph
				.createResource(directorIri, personClass)
					.addProperty(nameProp, directorName);
		
		// create the movie instance
		Resource interstellarMovie = graph
				.createResource(movieIri, movieClass)
					.addProperty(nameProp, movieName)
					.addProperty(datePublishedProp, "2014-11-07")
					.addProperty(directorProp, christopherNolanPerson);
		
		// printing each statement (triple)
		// list the statements in the Model
		StmtIterator iter = graph.listStatements();

		// print out the predicate, subject and object of each statement
		while (iter.hasNext()) {
		    Statement stmt      = iter.nextStatement();  // get next statement
		    Resource  subject   = stmt.getSubject();     // get the subject
		    Property  predicate = stmt.getPredicate();   // get the predicate
		    RDFNode   object    = stmt.getObject();      // get the object

		    System.out.print(subject.toString());
		    System.out.print("\t");
		    System.out.print(predicate.toString());
		    System.out.print("\t");
		    
		    if (object instanceof Resource) {
		       System.out.print(object.toString());
		    } else {
		        // object is a literal
		        System.out.print("\"" + object.toString() + "\"");
		    }

		    System.out.println(" .");
		}
		
		
		// printing whole graph content in JSON-LD syntax
		graph.write(System.out, "JSON-LD");
	}
}
