/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.core.Quad;

public class LangNQuads
extends LangNTuple<Quad> {
    private Node currentGraph = null;

    public LangNQuads(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.NQUADS;
    }

    @Override
    protected final void runParser() {
        while (this.hasNext()) {
            Quad x = this.parseOne();
            if (x == null) continue;
            this.dest.quad(x);
        }
    }

    @Override
    protected final Quad parseOne() {
        Token xToken;
        Token oToken;
        Token pToken;
        Token sToken = this.nextToken();
        if (sToken.getType() == TokenType.EOF) {
            this.exception(sToken, "Premature end of file: %s", sToken);
        }
        if ((pToken = this.nextToken()).getType() == TokenType.EOF) {
            this.exception(pToken, "Premature end of file: %s", pToken);
        }
        if ((oToken = this.nextToken()).getType() == TokenType.EOF) {
            this.exception(oToken, "Premature end of file: %s", oToken);
        }
        if ((xToken = this.nextToken()).getType() == TokenType.EOF) {
            this.exception(xToken, "Premature end of file: Quad not terminated by DOT: %s", xToken);
        }
        Node c = null;
        if (xToken.getType() != TokenType.DOT) {
            this.checkIRIOrBNode(xToken);
            c = this.tokenAsNode(xToken);
            xToken = this.nextToken();
            this.currentGraph = c;
        } else {
            c = Quad.defaultGraphNodeGenerated;
            this.currentGraph = null;
        }
        this.checkIRIOrBNode(sToken);
        this.checkIRI(pToken);
        this.checkRDFTerm(oToken);
        Node s = this.tokenAsNode(sToken);
        Node p = this.tokenAsNode(pToken);
        Node o = this.tokenAsNode(oToken);
        if (xToken.getType() != TokenType.DOT) {
            this.exception(xToken, "Quad not terminated by DOT: %s", xToken);
        }
        return this.profile.createQuad(c, s, p, o, sToken.getLine(), sToken.getColumn());
    }

    @Override
    protected final Node tokenAsNode(Token token) {
        return this.profile.create(this.currentGraph, token);
    }
}

