/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpPropFunc
extends Op1 {
    private Node uri;
    private PropFuncArg subjectArgs;
    private PropFuncArg objectArgs;

    public OpPropFunc(Node uri, PropFuncArg args1, PropFuncArg args2, Op op) {
        super(op);
        this.uri = uri;
        this.subjectArgs = args1;
        this.objectArgs = args2;
    }

    public PropFuncArg getSubjectArgs() {
        return this.subjectArgs;
    }

    public PropFuncArg getObjectArgs() {
        return this.objectArgs;
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Node getProperty() {
        return this.uri;
    }

    @Override
    public Op1 copy(Op op) {
        return new OpPropFunc(this.uri, this.subjectArgs, this.objectArgs, op);
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpPropFunc)) {
            return false;
        }
        OpPropFunc procFunc = (OpPropFunc)other;
        if (!OpPropFunc.isomorphic(this.getSubjectArgs(), procFunc.getSubjectArgs(), labelMap)) {
            return false;
        }
        if (!OpPropFunc.isomorphic(this.getObjectArgs(), procFunc.getObjectArgs(), labelMap)) {
            return false;
        }
        return this.getSubOp().equalTo(procFunc.getSubOp(), labelMap);
    }

    private static boolean isomorphic(PropFuncArg pfa1, PropFuncArg pfa2, NodeIsomorphismMap labelMap) {
        if (pfa1 == null && pfa2 == null) {
            return true;
        }
        if (pfa1 == null) {
            return false;
        }
        if (pfa2 == null) {
            return false;
        }
        List<Node> list1 = pfa1.getArgList();
        List<Node> list2 = pfa2.getArgList();
        return Iso.isomorphicNodes(list1, list2, labelMap);
    }

    @Override
    public String getName() {
        return "propfunc";
    }
}

