/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.journaling;

import java.util.Objects;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.journaling.Operation;

public abstract class QuadOperation<SelfType extends QuadOperation<SelfType, InverseType>, InverseType extends QuadOperation<InverseType, SelfType>>
implements Operation.InvertibleOperation<Quad, DatasetGraph, SelfType, InverseType> {
    protected final Quad quad;

    public QuadOperation(Quad q) {
        this.quad = q;
    }

    public static class QuadDeletion
    extends QuadOperation<QuadDeletion, QuadAddition> {
        public QuadDeletion(Quad q) {
            super(q);
        }

        @Override
        public Quad data() {
            return this.quad;
        }

        @Override
        public QuadAddition inverse() {
            return new QuadAddition(this.data());
        }

        @Override
        public void actOn(DatasetGraph dsg) {
            dsg.delete(this.data());
        }

        public String toString() {
            return "DELETE " + super.toString();
        }

        public int hashCode() {
            return Objects.hash(this.data());
        }

        public boolean equals(Object other) {
            if (other instanceof QuadDeletion) {
                return this.data().equals(((QuadDeletion)other).data());
            }
            return false;
        }
    }

    public static class QuadAddition
    extends QuadOperation<QuadAddition, QuadDeletion> {
        public QuadAddition(Quad q) {
            super(q);
        }

        @Override
        public Quad data() {
            return this.quad;
        }

        @Override
        public QuadDeletion inverse() {
            return new QuadDeletion(this.data());
        }

        @Override
        public void actOn(DatasetGraph dsg) {
            dsg.add(this.data());
        }

        public String toString() {
            return "ADD " + super.toString();
        }

        public int hashCode() {
            return Objects.hash(this.data());
        }

        public boolean equals(Object other) {
            if (other instanceof QuadAddition) {
                return this.data().equals(((QuadAddition)other).data());
            }
            return false;
        }
    }
}

