/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;

public abstract class FunctionBase
implements Function {
    String uri = null;
    protected ExprList arguments = null;
    private FunctionEnv env;

    @Override
    public final void build(String uri, ExprList args) {
        this.uri = uri;
        this.arguments = args;
        this.checkBuild(uri, args);
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        this.env = env;
        if (args == null) {
            throw new ARQInternalErrorException("FunctionBase: Null args list");
        }
        ArrayList<NodeValue> evalArgs = new ArrayList<NodeValue>();
        for (Expr e2 : args) {
            NodeValue x = e2.eval(binding, env);
            evalArgs.add(x);
        }
        NodeValue nv = this.exec(evalArgs);
        this.arguments = null;
        return nv;
    }

    public Context getContext() {
        return this.env.getContext();
    }

    public abstract NodeValue exec(List<NodeValue> var1);

    public abstract void checkBuild(String var1, ExprList var2);
}

