package rs.ac.bg.fon.ai.inteligentniSistemi.sparql;

import java.util.List;

import org.apache.jena.rdf.model.Model;

import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.persistence.RDFModel;
import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.services.MovieService;

public class Main {

	public static void main(String[] args) {

		MovieService movieService = new MovieService(RDFModel.getInstance().getGraph());

		// query 1
		System.out.print("\n\n");
		System.out.println("All person names:");
		List<String> personNames = movieService.getAllPersonNames();

		for (String name : personNames) {
			System.out.println(name);
		}

		// query 2
		System.out.print("\n\n");
		System.out.println("Describing all persons");
		Model personGraph = movieService.describeAllPersons();
		personGraph.write(System.out, "JSON-LD");

		// query 3
		System.out.print("\n\n");
		System.out.println("Titles of all movies released in 2010 and after:");
		List<String> movies = movieService.getAllMoviesNewerThan2010();

		for (String movie : movies) {
			System.out.println(movie);
		}

		// query 4
		System.out.print("\n\n");
		System.out.println("Titles of all movies released directed by J. J. Abrams:");
		List<String> movies1 = movieService.getAllMoviesByJJAbrams();

		for (String movie : movies1) {
			System.out.println(movie);
		}
	}
}
