package rs.ac.bg.fon.ai.inteligentniSistemi.sparql.dbpedia.services;

import java.util.List;

import org.apache.jena.query.ResultSet;

import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.query.QueryExecutor;
import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.util.Constants;

public class DBpediaService {

	private QueryExecutor queryExecutor = new QueryExecutor();
	private static final String DBPEDIA_SPARQL_ENDPOINT = "http://dbpedia.org/sparql";
	
	public List<String> getFirstPersonShooters() {
		String query = 
			"PREFIX category: <"+Constants.DBPEDIA_CATEGORY+">" +
			"PREFIX dcterms: <"+Constants.DC_TERMS+">" +
			"PREFIX rdfs: <"+Constants.RDFS_NS+"> " +
			
			"SELECT ?title " + 
			"WHERE { " + 
				"?game dcterms:subject category:First-person_shooters ; " + 
				"rdfs:label ?title . " +
					
				"FILTER ( lang(?title) = \"en\" ) " +
			"} " + 
			"ORDER by ?title";
		
		return queryExecutor.executeSelectQueryOverSparqlEndpoint(query, "title", DBPEDIA_SPARQL_ENDPOINT);
	}
	
	public List<String> getSpanishMovies() {
		String query = 
			"PREFIX rdfs: <"+Constants.RDFS_NS+"> " +
			"PREFIX category: <"+Constants.DBPEDIA_CATEGORY+">" +
			"PREFIX dcterms: <"+Constants.DC_TERMS+">" +
			
			"SELECT ?title " +
			"WHERE { " + 
				"?movie dcterms:subject category:Spanish_films ; " +
					"rdfs:label ?title . " +
				
				"FILTER ( lang(?title) = \"en\" ) " +
			"}" + 
			"ORDER by ?title";
		
		return queryExecutor.executeSelectQueryOverSparqlEndpoint(query, "title", DBPEDIA_SPARQL_ENDPOINT);
	}
	
	public List<String> getChurchesFromParis() {
		String query = 
			"PREFIX rdfs: <"+Constants.RDFS_NS+"> " +
			"PREFIX dcterms: <"+Constants.DC_TERMS+">" +
			"PREFIX category: <"+Constants.DBPEDIA_CATEGORY+"> " +
			"PREFIX skos: <"+Constants.SKOS+"> " +

			"SELECT ?title " +
			"WHERE { " +
				"?church rdfs:label ?title ; " +
					"dcterms:subject ?subject . " +

				"?subject skos:broader category:Churches_in_Paris. " +
				
				"FILTER ( lang(?title) = \"en\" ) " +
			"} " +
			"ORDER by ?title";
		
		return queryExecutor.executeSelectQueryOverSparqlEndpoint(query, "title", DBPEDIA_SPARQL_ENDPOINT);
	}
	
	public ResultSet getOldPeopleFromBerlin() {
		String query = 
			"PREFIX xsd: <"+Constants.XSD+"> " +
			"PREFIX foaf: <"+Constants.FOAF_NS+"> " +
			"PREFIX dbo: <"+Constants.DBPEDIA_ONTOLOGY+"> " +
			"PREFIX dbpedia: <"+Constants.DBPEDIA+"> " +
						
			"SELECT ?name ?birth ?death ?person " +
			"WHERE { " +
				"?person dbo:birthPlace dbpedia:Berlin ; " +
					"dbo:birthDate ?birth ; " +
					"foaf:name ?name ; " +
					"dbo:deathDate ?death ; " +
				
				"FILTER (?birth < \"1900-01-01\"^^xsd:date) . " +
			"}";
		
		return queryExecutor.executeSelectSparqlQuery(query, DBPEDIA_SPARQL_ENDPOINT);
	}
}
