package rs.ac.bg.fon.ai.inteligentniSistemi.sparql.persistence;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.util.Constants;

public class RDFModel {
	
	private static final String dataSourcePath = "data";

	private Model graph;
	
	private static RDFModel INSTANCE;
	
	private RDFModel (){
		graph = ModelFactory.createDefaultModel();
		graph.setNsPrefix("Person", Constants.SCHEMA + "Person");
		graph.setNsPrefix("Movie", Constants.SCHEMA + "Movie");
		graph.setNsPrefix("name", Constants.SCHEMA + "name");
		graph.setNsPrefix("description", Constants.SCHEMA + "description");
		graph.setNsPrefix("actors", Constants.SCHEMA + "actors");
		graph.setNsPrefix("datePublished", Constants.SCHEMA + "datePublished");
		graph.setNsPrefix("director", Constants.SCHEMA + "director");
		graph.setNsPrefix("duration", Constants.SCHEMA + "duration");
		graph.setNsPrefix("genre", Constants.SCHEMA + "genre");
		graph.setNsPrefix("keywords", Constants.SCHEMA + "keywords");
		
		loadDataFromFiles(dataSourcePath);
	}
	
	public static RDFModel getInstance(){
		if (INSTANCE == null) {
			INSTANCE = new RDFModel();
		}
		
		return INSTANCE;
	}
	
	private void loadDataFromFiles(String folderPath) {
		File folder = new File(folderPath);
		File[] listOfFiles = folder.listFiles();

		for (int i = 0; i < listOfFiles.length; i++) {
			if (listOfFiles[i].isFile()) {
				try {
					FileReader in = new FileReader(listOfFiles[i]);
					graph.read(in, "", "JSON-LD");
				} catch (FileNotFoundException e) {
					System.out.println(e);
				}
			}
		}
	}
	
	public Model getGraph() {
		return graph;
	}
	
	public void printOut(){
		graph.write(System.out, "JSON-LD");
	}
}