package rs.ac.bg.fon.ai.inteligentniSistemi.sparql.services;

import java.util.List;

import org.apache.jena.rdf.model.Model;

import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.query.QueryExecutor;
import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.util.Constants;

public class MovieService {
	
	private Model model;
	private QueryExecutor queryExecutor = new QueryExecutor();
	
	
	public MovieService (Model model) {
		this.model = model;
	}
	
	/**
	 * Retrieves names of all persons in the graph
	 * 
	 * @return list of names
	 */
	public List<String> getAllPersonNames () {
		String query = 
			"PREFIX schema: <"+Constants.SCHEMA+"> " + 
			"PREFIX rdf: <"+Constants.RDF+"> " + 
			"SELECT ?name " +
			"WHERE { " +
				"?person rdf:type schema:Person . " +
				"?person schema:name ?name . " +
			"}";
		
		return queryExecutor
				.executeSelectQueryOverModel(query, "name", model);
	}
	
	/**
	 * Retrieves a graph (Model instance) containing all properties 
	 * for all persons in the graph
	 * 
	 * @return Model instance with all properties for all persons
	 */
	public Model describeAllPersons() {
		String query = 
			"PREFIX schema: <"+Constants.SCHEMA+"> " + 
			"PREFIX rdf: <"+Constants.RDF+"> " + 
			"DESCRIBE ?person " +
			"WHERE { " +
				"?person rdf:type schema:Person . " +
			"}";
		
		return queryExecutor
				.executeDescribeSparqlQuery(query, model);
	}

	/**
	 * Retrieves names of all movies that are released after the date 
	 * 01.01.2010.
	 * 
	 * @return list of movie names
	 */
	public List<String> getAllMoviesNewerThan2010() {
		String queryString = 
			"PREFIX schema: <"+Constants.SCHEMA+"> " + 
			"PREFIX rdf: <"+Constants.RDF+"> " + 
			"SELECT ?name " + 
			"WHERE  { " + 
				"?movie rdf:type schema:Movie ." +
				"?movie schema:name ?name ." + 
				"?movie schema:datePublished ?date ." + 
				
				"FILTER (?date > \"2010-01-01\")" +
			"}";

		return queryExecutor
				.executeSelectQueryOverModel(queryString, "name", model);
	}
	
	/**
	 * Retrieves names of all movies that are directed by J. J. Abrams
	 * 
	 * @return list of movie names
	 */
	public List<String> getAllMoviesByJJAbrams() {
		String query = 
			"PREFIX schema: <"+Constants.SCHEMA+"> " + 
			"PREFIX rdf: <"+Constants.RDF+"> " + 
			"SELECT DISTINCT ?name " +
			"WHERE { " +
				"?movie rdf:type schema:Movie . " +
				"?movie schema:name ?name . " +
				"?movie schema:director ?director . " +

				"?director rdf:type schema:Person . " +
				"?director schema:name \"J.J. Abrams\" . " +
			"}";

		return queryExecutor
				.executeSelectQueryOverModel(query, "name", model);
	}
}
