/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.layout1.FormatterSimple;
import com.hp.hpl.jena.sdb.sql.SAPStorageType;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.sql.TableUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterSimpleSAP
extends FormatterSimple {
    private static Logger log = LoggerFactory.getLogger(FormatterSimpleSAP.class);
    private static final String colDecl = "NVARCHAR(" + UriWidth + ") NOT NULL";
    private SAPStorageType storageType;

    public FormatterSimpleSAP(SDBConnection connection, SAPStorageType storageType) {
        super(connection);
        this.storageType = storageType;
    }

    @Override
    public void truncate() {
        try {
            this.connection().exec("DELETE FROM Triples");
        }
        catch (SQLException ex) {
            log.warn("Exception truncating tables");
            throw new SDBException("SQLException truncating tables", ex);
        }
    }

    @Override
    public void format() {
        this.reformatPrefixesWorker(false);
        this.reformatDataWorker();
    }

    private void reformatPrefixesWorker() {
        this.reformatPrefixesWorker(false);
    }

    private void reformatPrefixesWorker(boolean loadPrefixes) {
        try {
            this.dropTable("Prefixes");
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE Prefixes (", "    prefix NVARCHAR(50) NOT NULL ,", "    uri NVARCHAR(500) NOT NULL", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE Prefixes ADD PRIMARY KEY (prefix)"));
            if (loadPrefixes) {
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('x',       'http://example/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('ex',      'http://example.org/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('rdf',     'http://www.w3.org/1999/02/22-rdf-syntax-ns#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('rdfs',    'http://www.w3.org/2000/01/rdf-schema#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('xsd',     'http://www.w3.org/2001/XMLSchema#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('owl' ,    'http://www.w3.org/2002/07/owl#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('foaf',    'http://xmlns.com/foaf/0.1/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('dc',      'http://purl.org/dc/elements/1.1/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('dcterms', 'http://purl.org/dc/terms/')");
            }
        }
        catch (SQLException ex) {
            log.warn("Exception resetting table 'Prefixes'");
            throw new SDBException("SQLException resetting table 'Prefixes'", ex);
        }
    }

    private void reformatDataWorker() {
        try {
            this.dropTable("Triples");
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE Triples", "(", "  s " + colDecl + " ,", "  p " + colDecl + " ,", "  o " + colDecl, ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE Triples ADD PRIMARY KEY (s,p,o)"));
        }
        catch (SQLException ex) {
            log.warn("Exception resetting table 'Triples'");
            throw new SDBException("SQLException resetting table 'Triples'", ex);
        }
    }

    protected void dropTable(String tableName) {
        TableUtils.dropTable(this.connection(), tableName);
    }

    @Override
    public void dropIndexes() {
        try {
            this.connection().exec("DROP INDEX IF EXISTS PredObj");
            this.connection().exec("DROP INDEX IF EXISTS ObjSubj");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException dropping indexes for table 'Triples'", ex);
        }
    }
}

