/**
 * 
 */
package rs.fon.is.jamendo.persistence;

import java.util.Date;

import thewebsemantic.Bean2RDF;
import thewebsemantic.RDF2Bean;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.util.FileManager;

public class DataModelManager {

	private RDF2Bean reader;
	private Bean2RDF writer;
	
	private static final String directory = "tdb";
	private Dataset dataset;

	private static DataModelManager INSTANCE;
	
	private DataModelManager() { 
		dataset = TDBFactory.createDataset(directory);
		
		reader = new RDF2Bean(getModel());
		writer = new Bean2RDF(getModel());
	}

	public static DataModelManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new DataModelManager();
		}
		return INSTANCE;
	}

	public Model getModel() {
		return dataset.getDefaultModel();
	}

	public RDF2Bean getReader() {
		return reader;
	}

	public Bean2RDF getWriter() {
		return writer;
	}
	
	public void readData(String filename, String syntax) {
		System.out.println("Importing data - " + new Date());
		FileManager.get().readModel(dataset.getDefaultModel(), filename, syntax);
		System.out.println("Import finished - " + new Date());
	}
	
	public void closeDataModel() {
		dataset.close();
	}

}
