/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core;

import com.hp.hpl.jena.sdb.core.ScopeStatus;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sparql.core.Var;
import org.apache.jena.atlas.iterator.Action;
import org.apache.jena.atlas.iterator.Filter;
import org.apache.jena.atlas.iterator.Transform;

public class ScopeEntry {
    Var var;
    SqlColumn column;
    ScopeStatus status;
    public static Filter<ScopeEntry> OptionalFilter = new Filter<ScopeEntry>(){

        public boolean accept(ScopeEntry item) {
            return item.getStatus() == ScopeStatus.OPTIONAL;
        }
    };
    public static Transform<ScopeEntry, Var> ToVar = new Transform<ScopeEntry, Var>(){

        public Var convert(ScopeEntry item) {
            return item.getVar();
        }
    };
    public static Action<ScopeEntry> SetOpt = new Action<ScopeEntry>(){

        public void apply(ScopeEntry item) {
            item.setStatus(ScopeStatus.OPTIONAL);
        }
    };

    public ScopeEntry(Var var, SqlColumn column) {
        this(var, column, ScopeStatus.FIXED);
    }

    private ScopeEntry(Var var, SqlColumn column, ScopeStatus status) {
        this.var = var;
        this.column = column;
        this.status = status;
    }

    public void reset(Var var, SqlColumn column, ScopeStatus status) {
        this.var = var;
        this.column = column;
        this.status = status;
    }

    public ScopeEntry duplicate() {
        return new ScopeEntry(this.var, this.column, this.status);
    }

    public SqlColumn getColumn() {
        return this.column;
    }

    public ScopeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScopeStatus newStatus) {
        this.status = newStatus;
    }

    public boolean isOptional() {
        return this.hasStatus(ScopeStatus.OPTIONAL);
    }

    public boolean isFixed() {
        return this.hasStatus(ScopeStatus.FIXED);
    }

    public boolean hasStatus(ScopeStatus testStatus2) {
        return this.status == testStatus2;
    }

    public Var getVar() {
        return this.var;
    }

    public String toString() {
        return "(" + this.var + ", " + this.column + "/" + this.status.name() + ")";
    }
}

