/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2;

import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.TableUtils;
import com.hp.hpl.jena.sdb.store.StoreFormatterBase;
import java.sql.SQLException;

public abstract class FmtLayout2
extends StoreFormatterBase {
    protected static String[] triplesIndexCols = new String[]{"(o, s)", "(p, o)"};
    protected static String[] triplesIndexNames = new String[]{"ObjSubj", "PredObj"};
    protected static String[] quadIndexCols = new String[]{"(s, p, o)", "(p, o, s)", "(o, s, p)", "(g, p, o)", "(g, o, s)"};
    protected static String[] quadIndexNames = new String[]{"SubjPredObj", "PredObjSubj", "ObjSubjPred", "GraPredObj", "GraObjSubj"};

    public FmtLayout2(SDBConnection connection) {
        super(connection);
    }

    @Override
    public void format() {
        this.formatTablePrefixes();
        this.formatTableNodes();
        this.formatTableTriples();
        this.formatTableQuads();
    }

    @Override
    public void truncate() {
        this.truncateTablePrefixes();
        this.truncateTableNodes();
        this.truncateTableTriples();
        this.truncateTableQuads();
    }

    @Override
    public void addIndexes() {
        this.addIndexesTableTriples();
        this.addIndexesTableQuads();
    }

    @Override
    public void dropIndexes() {
        this.dropIndexesTableTriples();
        this.dropIndexesTableQuads();
    }

    protected String syntaxCreateIndex(String indexName, String cols, String table) {
        return String.format("CREATE INDEX %s ON %s %s", indexName, cols, table);
    }

    protected String syntaxDropIndex(String indexName, String table) {
        return String.format("DROP INDEX %s", indexName);
    }

    protected void addIndexesTableTriples() {
        try {
            for (int i = 0; i < triplesIndexNames.length; ++i) {
                this.connection().exec(this.syntaxCreateIndex(triplesIndexNames[i], TableDescTriples.name(), triplesIndexCols[i]));
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException indexing table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void dropIndexesTableTriples() {
        try {
            for (int i = 0; i < triplesIndexNames.length; ++i) {
                this.connection().exec(this.syntaxDropIndex(triplesIndexNames[i], TableDescTriples.name()));
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException dropping indexes for table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void addIndexesTableQuads() {
        try {
            for (int i = 0; i < quadIndexNames.length; ++i) {
                this.connection().exec(this.syntaxCreateIndex(quadIndexNames[i], TableDescQuads.name(), quadIndexCols[i]));
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException indexing table '" + TableDescQuads.name() + "'", ex);
        }
    }

    protected void dropIndexesTableQuads() {
        try {
            for (int i = 0; i < quadIndexNames.length; ++i) {
                this.connection().exec(this.syntaxDropIndex(quadIndexNames[i], TableDescQuads.name()));
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException dropping indexes for table '" + TableDescQuads.name() + "'", ex);
        }
    }

    protected abstract void formatTableTriples();

    protected abstract void formatTableNodes();

    protected abstract void formatTableQuads();

    protected abstract void formatTablePrefixes();

    protected void truncateTableTriples() {
        this.truncateTable(TableDescTriples.name());
    }

    protected void truncateTableQuads() {
        this.truncateTable(TableDescQuads.name());
    }

    protected void truncateTableNodes() {
        this.truncateTable(TableDescNodes.name());
    }

    protected void truncateTablePrefixes() {
        this.truncateTable(TablePrefixes.name());
    }

    protected void truncateTable(String tableName) {
        try {
            this.connection().exec("DELETE FROM " + tableName);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException truncating table: " + tableName, ex);
        }
    }

    protected void dropTable(String tableName) {
        TableUtils.dropTable(this.connection(), tableName);
    }
}

