/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.sdb.layout2.FmtLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2HashH2
extends FmtLayout2 {
    public FmtLayout2HashH2(SDBConnection connection) {
        super(connection);
    }

    @Override
    protected void formatTableTriples() {
        String tname = TableDescTriples.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + tname + " (", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        String tname = TableDescQuads.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + tname + " (", "    g BIGINT NOT NULL,", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected String syntaxDropIndex(String indexName, String table) {
        return String.format("DROP INDEX IF EXISTS %s", indexName);
    }

    @Override
    protected void formatTableNodes() {
        String tname = TableDescNodes.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + tname + " (", "   hash BIGINT NOT NULL,", "   lex CLOB NOT NULL,", "   lang varchar NOT NULL default E'',", "   datatype varchar(200) NOT NULL default '',", "   type integer NOT NULL default E'0',", "   PRIMARY KEY (hash)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        String tname = TablePrefixes.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + tname + " (", "    prefix VARCHAR(50) NOT NULL ,", "    uri VARCHAR(500) NOT NULL ,", "    CONSTRAINT " + tname + "_PK PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }
}

