/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.atlas.lib.StrUtils;

public class TableDump {
    public static String dumpDB(Connection dbConn) {
        String columnNameQuote = "";
        DatabaseMetaData dbMetaData = null;
        try {
            dbMetaData = dbConn.getMetaData();
            StringBuffer result = new StringBuffer();
            String catalog = null;
            String schema = null;
            String tables = null;
            String hostname = "";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostname = addr.getHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            result.append("Host: " + hostname + " " + System.getProperty("os.name") + " ");
            result.append(System.getProperty("os.version") + " ");
            result.append(System.getProperty("os.arch") + "\n");
            result.append("Database: " + dbMetaData.getDatabaseProductName() + " (" + dbMetaData.getDatabaseProductVersion() + ")\n");
            result.append("Driver name: " + dbMetaData.getDriverName() + " (" + dbMetaData.getDriverVersion() + ")\n");
            ResultSet rs = dbMetaData.getTables(catalog, schema, tables, null);
            if (!rs.next()) {
                System.err.println("Unable to find any tables matching: catalog=" + catalog + " schema=" + schema + " tables=" + tables);
                rs.close();
            } else {
                do {
                    String tableName = rs.getString("TABLE_NAME");
                    String tableType = rs.getString("TABLE_TYPE");
                    if (!"TABLE".equalsIgnoreCase(tableType)) continue;
                    result.append("\n-- " + tableName);
                    result.append("\nCREATE TABLE " + tableName + " (\n");
                    ResultSet tableMetaData = dbMetaData.getColumns(null, null, tableName, "%");
                    boolean firstLine = true;
                    while (tableMetaData.next()) {
                        if (firstLine) {
                            firstLine = false;
                        } else {
                            result.append(",\n");
                        }
                        String columnName = tableMetaData.getString("COLUMN_NAME");
                        String columnType = tableMetaData.getString("TYPE_NAME");
                        int columnSize = tableMetaData.getInt("COLUMN_SIZE");
                        String nullable = tableMetaData.getString("IS_NULLABLE");
                        String nullString = "NULL";
                        if ("NO".equalsIgnoreCase(nullable)) {
                            nullString = "NOT NULL";
                        }
                        result.append("    " + columnNameQuote + columnName + columnNameQuote + " " + columnType + " (" + columnSize + ")" + " " + nullString);
                    }
                    tableMetaData.close();
                    try {
                        ResultSet primaryKeys = dbMetaData.getPrimaryKeys(catalog, schema, tableName);
                        String primaryKeyName = null;
                        StringBuffer primaryKeyColumns = new StringBuffer();
                        while (primaryKeys.next()) {
                            String thisKeyName = primaryKeys.getString("PK_NAME");
                            if (thisKeyName != null && primaryKeyName == null || thisKeyName == null && primaryKeyName != null || thisKeyName != null && !thisKeyName.equals(primaryKeyName) || primaryKeyName != null && !primaryKeyName.equals(thisKeyName)) {
                                if (primaryKeyColumns.length() > 0) {
                                    result.append(",\n    PRIMARY KEY ");
                                    if (primaryKeyName != null) {
                                        result.append(primaryKeyName);
                                    }
                                    result.append("(" + primaryKeyColumns.toString() + ")");
                                }
                                primaryKeyColumns = new StringBuffer();
                                primaryKeyName = thisKeyName;
                            }
                            if (primaryKeyColumns.length() > 0) {
                                primaryKeyColumns.append(", ");
                            }
                            primaryKeyColumns.append(primaryKeys.getString("COLUMN_NAME"));
                        }
                        if (primaryKeyColumns.length() > 0) {
                            result.append(",\n    PRIMARY KEY ");
                            if (primaryKeyName != null) {
                                result.append(primaryKeyName);
                            }
                            result.append(" (" + primaryKeyColumns.toString() + ")");
                        }
                    }
                    catch (SQLException e) {
                        System.err.println("Unable to get primary keys for table " + tableName + " because " + e);
                    }
                    result.append("\n);\n");
                    try {
                        ResultSet indexes = dbMetaData.getIndexInfo(null, null, tableName, false, false);
                        HashMap index2col = new HashMap();
                        HashMap<String, Boolean> index2unique = new HashMap<String, Boolean>();
                        while (indexes.next()) {
                            Boolean nonUnique = indexes.getBoolean("NON_UNIQUE");
                            String name = indexes.getString("INDEX_NAME");
                            String col = indexes.getString("COLUMN_NAME");
                            if (!index2col.containsKey(name)) {
                                index2col.put(name, new ArrayList());
                            }
                            ((List)index2col.get(name)).add(col);
                            index2unique.put(name, nonUnique == false);
                        }
                        for (String index : index2col.keySet()) {
                            List cols = (List)index2col.get(index);
                            result.append("CREATE ");
                            if (((Boolean)index2unique.get(index)).booleanValue()) {
                                result.append("UNIQUE ");
                            }
                            result.append("INDEX " + index + " ON " + tableName + " (");
                            result.append(StrUtils.strjoin((String)", ", (String[])cols.toArray(new String[0])));
                            result.append(")\n");
                        }
                    }
                    catch (SQLException e) {
                        System.err.println("Unable to get indexes for table " + tableName + " because " + e);
                    }
                } while (rs.next());
                rs.close();
            }
            return result.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

