/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterBlockTriples;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.main.StageGeneratorGeneric;
import com.hp.hpl.jena.sparql.util.Context;

public class StageBuilder {
    public static StageGenerator executeInline = new StageGenerator(){

        @Override
        public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
            return QueryIterBlockTriples.create(input, pattern, execCxt);
        }
    };

    public static void init() {
        StageGenerator gen = StageBuilder.getGenerator(ARQ.getContext());
        if (gen == null) {
            gen = StageBuilder.standardGenerator();
            StageBuilder.setGenerator(ARQ.getContext(), gen);
        }
    }

    public static void setGenerator(Context context, StageGenerator builder) {
        context.set(ARQ.stageGenerator, builder);
    }

    public static StageGenerator getGenerator(Context context) {
        if (context == null) {
            return null;
        }
        return (StageGenerator)context.get(ARQ.stageGenerator);
    }

    public static StageGenerator getGenerator() {
        return StageBuilder.getGenerator(ARQ.getContext());
    }

    public static StageGenerator standardGenerator() {
        return new StageGeneratorGeneric();
    }

    public static StageGenerator chooseStageGenerator(Context context) {
        StageGenerator gen = StageBuilder.getGenerator(context);
        if (gen == null) {
            gen = new StageGeneratorGeneric();
        }
        return gen;
    }
}

