/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import java.lang.reflect.Array;
import thewebsemantic.Bean2RDF;
import thewebsemantic.Saver;

public class ArraySaver
extends Saver {
    public void save(Bean2RDF writer, Resource subject, Property property, Object array) {
        if (array == null) {
            return;
        }
        Seq s = this.getSeq(subject, property);
        int len = Array.getLength(array);
        int i = 0;
        while (i < len) {
            Object o = Array.get(array, i);
            if (o != null) {
                s.add(writer.toRDFNode(o));
            }
            ++i;
        }
    }

    protected Seq getSeq(Resource subject, Property property) {
        try {
            Seq s = subject.getRequiredProperty(property).getSeq();
            NodeIterator it = s.iterator();
            while (it.hasNext()) {
                RDFNode node = it.nextNode();
                if (!node.isAnon()) continue;
                ((Resource)node.as(Resource.class)).removeProperties();
            }
            it.close();
            s.removeProperties();
            subject.removeAll(property);
        }
        catch (PropertyNotFoundException s) {
            // empty catch block
        }
        Seq seq = subject.getModel().createSeq();
        subject.addProperty(property, (RDFNode)seq);
        return seq;
    }
}

