/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.List;

public class ClassBuilder {
    OntModel m;
    private static String indent = "   ";

    public void create(String uri, String namespace, String type) {
        StringBuilder buffer = new StringBuilder();
        OntModel m = ModelFactory.createOntologyModel();
        m.read(uri);
        ExtendedIterator it = m.listOntProperties();
        List props = it.toList();
        for (OntProperty ontProperty : props) {
            if (!ontProperty.getNameSpace().equals(namespace)) continue;
            if (ontProperty.isDatatypeProperty()) {
                buffer.append(this.literalSetter(namespace, type, ontProperty));
                buffer.append("\n");
                buffer.append(this.literalGetter(namespace, type, ontProperty));
                buffer.append("\n");
                continue;
            }
            if (ontProperty.isObjectProperty()) {
                buffer.append(this.resourceSetter(namespace, type, ontProperty));
                buffer.append("\n");
                buffer.append(this.resourceGetter(namespace, type, ontProperty));
                buffer.append("\n");
                continue;
            }
            if (RDFS.Literal.equals((Object)ontProperty.getRange())) {
                buffer.append(this.literalSetter(namespace, type, ontProperty));
                buffer.append("\n");
                buffer.append(this.literalGetter(namespace, type, ontProperty));
                buffer.append("\n");
                continue;
            }
            buffer.append(this.resourceSetter(namespace, type, ontProperty));
            buffer.append("\n");
            buffer.append(this.resourceGetter(namespace, type, ontProperty));
            buffer.append("\n");
        }
        System.out.println(buffer);
    }

    private Object resourceGetter(String namespace, String type, OntProperty ontProperty) {
        return String.valueOf(indent) + "public " + this.resourceCollection(ontProperty) + ontProperty.getURI().substring(namespace.length()) + "();";
    }

    private Object resourceSetter(String namespace, String type, OntProperty ontProperty) {
        return String.valueOf(this.functional(ontProperty)) + indent + "public " + type + " " + ontProperty.getURI().substring(namespace.length()) + "(Object t);";
    }

    private Object literalGetter(String namespace, String type, OntProperty ontProperty) {
        return String.valueOf(indent) + "public " + this.literalCollection(ontProperty) + ontProperty.getURI().substring(namespace.length()) + "();";
    }

    private String literalCollection(OntProperty ontProperty) {
        return ontProperty.isFunctionalProperty() ? "String " : "Collection<String> ";
    }

    private String resourceCollection(OntProperty ontProperty) {
        return ontProperty.isFunctionalProperty() ? "Thing " : "Collection<Thing> ";
    }

    private String literalSetter(String namespace, String type, OntProperty ontProperty) {
        return String.valueOf(this.functional(ontProperty)) + indent + "public " + type + " " + ontProperty.getURI().substring(namespace.length()) + "(Object o);";
    }

    private String functional(OntProperty ontProperty) {
        return ontProperty.isFunctionalProperty() ? String.valueOf(indent) + "@Functional\n" : "";
    }

    public static void main(String[] args) {
        new ClassBuilder().create("file:cim2003.owl", "http://iec.ch/TC57/2003/CIM-schema-cim10#", "CIM");
    }
}

