/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Date;
import java.util.logging.Level;
import thewebsemantic.Bean2RDF;
import thewebsemantic.PrimitiveWrapper;
import thewebsemantic.Symmetric;
import thewebsemantic.TypeWrapper;
import thewebsemantic.ValuesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldContext
extends ValuesContext {
    Field field;
    TypeWrapper type;
    boolean idField;

    public FieldContext(Object bean, Field p, boolean id) {
        this.subject = bean;
        this.field = p;
        this.type = TypeWrapper.wrap(p.getDeclaringClass());
        this.idField = id;
    }

    @Override
    public String uri() {
        return this.type.uri(this.field, this.field.getName());
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric(this.field);
    }

    private boolean isSymmetric(Field p) {
        return this.field.isAnnotationPresent(Symmetric.class) ? true : TypeWrapper.getRDFAnnotation(this.field).symmetric();
    }

    @Override
    public boolean isInverse() {
        return !"".equals(TypeWrapper.getRDFAnnotation(this.field).inverseOf());
    }

    @Override
    public String inverseOf() {
        return this.inverseOf(this.field);
    }

    @Override
    public boolean existsInModel(Model m) {
        return m.getGraph().contains(Node.createURI((String)this.uri()), Node.ANY, Node.ANY);
    }

    @Override
    public Object invokeGetter() {
        Object result = null;
        try {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            result = this.field.get(this.subject);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Error retrieving field value.", e);
        }
        return result;
    }

    @Override
    public void setProperty(Object v) {
        try {
            this.field.setAccessible(true);
            this.field.set(this.subject, v);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Could not set bean field " + this.field.getName(), e);
        }
    }

    public boolean isDate() {
        return this.type().equals(Date.class);
    }

    @Override
    public boolean isPrimitive() {
        return PrimitiveWrapper.isPrimitive(this.field.getType());
    }

    @Override
    public Class<?> type() {
        return this.field.getType();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> t() {
        return this.getGenericType((ParameterizedType)this.field.getGenericType());
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive(this.field);
    }

    @Override
    public boolean isId() {
        return this.idField;
    }

    @Override
    public AccessibleObject getAccessibleObject() {
        return this.field;
    }
}

