/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.rdf.model.Resource;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import thewebsemantic.AnnotationHelper;
import thewebsemantic.Bean2RDF;
import thewebsemantic.FieldContext;
import thewebsemantic.Transient;
import thewebsemantic.TypeWrapper;
import thewebsemantic.Util;
import thewebsemantic.ValuesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdFieldTypeWrapper
extends TypeWrapper {
    private Field idfield;
    private Field[] fields;
    private boolean uriid = false;

    public IdFieldTypeWrapper(Class<?> c, Field f, Field[] fields) {
        super(c);
        this.idfield = f;
        this.idfield.setAccessible(true);
        this.uriid = this.idfield.getType().equals(URI.class);
        this.fields = fields;
    }

    @Override
    public String id(Object bean) {
        Object result = null;
        try {
            if (!this.idfield.isAccessible()) {
                this.idfield.setAccessible(true);
            }
            result = this.idfield.get(bean);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Error retrieving id field value.", e);
        }
        return result.toString();
    }

    @Override
    public String uri(String id) {
        if (this.idfield.getType().equals(URI.class)) {
            return id;
        }
        return String.valueOf(this.typeUri()) + '/' + id;
    }

    @Override
    public String[] collections() {
        LinkedList<String> results = new LinkedList<String>();
        Field[] fieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().equals(Collection.class)) {
                results.add(field.getName());
            }
            ++n2;
        }
        return results.toArray(new String[0]);
    }

    @Override
    public ValuesContext getProperty(String name) {
        try {
            Field f = this.c.getDeclaredField(name);
            return new FieldContext(null, f, f.equals(this.idfield));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ValuesContext[] getValueContexts(Object o) {
        ArrayList<FieldContext> values = new ArrayList<FieldContext>();
        Field[] fieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!(field.equals(this.idfield) && this.uriid || field.isAnnotationPresent(Transient.class) || Modifier.isTransient(field.getModifiers()))) {
                values.add(new FieldContext(o, field, field.equals(this.idfield)));
            }
            ++n2;
        }
        return values.toArray(new ValuesContext[0]);
    }

    @Override
    public Object toBean(String uri) {
        try {
            return this.constructor != null ? this.constructor.newInstance(Util.last(uri)) : this.newinstance(uri);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Could not instantiate bean.", e);
            return null;
        }
    }

    private Object newinstance(String uri) throws Exception {
        Object o = this.c.newInstance();
        if (this.uriid && uri != null) {
            this.idfield.set(o, URI.create(uri));
        }
        return o;
    }

    @Override
    public Object toProxyBean(Resource source, AnnotationHelper jpa) {
        try {
            Class cls = jpa.getProxy(this.c);
            Object obj = cls.newInstance();
            if (this.uriid) {
                this.idfield.set(obj, URI.create(source.getURI()));
            }
            return obj;
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Exception caught while invoking default constructor on " + this.c, e);
            return null;
        }
    }
}

