/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import thewebsemantic.LocalizedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaHelper {
    public static Object convertLiteral(RDFNode node, Class<?> c) {
        return JenaHelper.convertLiteral((Literal)node.as(Literal.class), c);
    }

    public static Object convertLiteral(Literal l, Class<?> c) {
        if (c.equals(Date.class)) {
            return JenaHelper.date(l);
        }
        if (c.equals(Calendar.class)) {
            return ((XSDDateTime)l.getValue()).asCalendar();
        }
        if (c.equals(BigDecimal.class)) {
            return JenaHelper.bigDecimal(l);
        }
        if (Long.TYPE.equals(c)) {
            return l.getLong();
        }
        if (Double.TYPE.equals(c)) {
            return l.getDouble();
        }
        if (Character.TYPE.equals(c)) {
            return Character.valueOf(l.getValue().toString().charAt(0));
        }
        if (Short.TYPE.equals(c)) {
            return l.getShort();
        }
        if (LocalizedString.class.equals(c)) {
            return new LocalizedString(l);
        }
        return l.getValue();
    }

    public static Date date(Literal l) {
        XSDDateTime date = (XSDDateTime)l.getValue();
        return date.asCalendar().getTime();
    }

    public static Object bigDecimal(Literal l) {
        Double o = l.getDouble();
        System.out.println(o.getClass());
        return null;
    }

    public static Literal toLiteral(Model m, Object o) {
        if (o instanceof String) {
            return m.createTypedLiteral(o.toString());
        }
        if (o instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)o);
            return m.createTypedLiteral(c);
        }
        if (o instanceof Integer) {
            return m.createTypedLiteral(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return m.createTypedLiteral(((Long)o).longValue());
        }
        if (o instanceof Short) {
            return m.createTypedLiteral((Object)((Short)o));
        }
        if (o instanceof Float) {
            return m.createTypedLiteral(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return m.createTypedLiteral(((Double)o).doubleValue());
        }
        if (o instanceof Character) {
            return m.createTypedLiteral(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return m.createTypedLiteral(((Boolean)o).booleanValue());
        }
        if (o instanceof Calendar) {
            return m.createTypedLiteral((Calendar)o);
        }
        if (o instanceof BigDecimal) {
            return m.createTypedLiteral((Object)((BigDecimal)o).doubleValue(), (RDFDatatype)XSDDatatype.XSDdouble);
        }
        if (o instanceof BigInteger) {
            return m.createTypedLiteral((Object)((BigInteger)o));
        }
        if (o instanceof URI) {
            return m.createTypedLiteral(o, (RDFDatatype)XSDDatatype.XSDanyURI);
        }
        return null;
    }
}

