/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import thewebsemantic.PrimitiveWrapper;
import thewebsemantic.Symmetric;
import thewebsemantic.TypeWrapper;
import thewebsemantic.ValuesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NullPropertyContext
extends ValuesContext {
    PropertyDescriptor property;
    TypeWrapper type;

    public NullPropertyContext(TypeWrapper t, PropertyDescriptor p) {
        this.property = p;
        this.type = t;
    }

    @Override
    public String uri() {
        return this.type.uri(this.property.getReadMethod(), this.property.getName());
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric(this.property);
    }

    private boolean isSymmetric(PropertyDescriptor p) {
        return p.getReadMethod().isAnnotationPresent(Symmetric.class) ? true : TypeWrapper.getRDFAnnotation(p.getReadMethod()).symmetric();
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive(this.property.getReadMethod());
    }

    @Override
    public boolean existsInModel(Model m) {
        return m.getGraph().contains(Node.createURI((String)this.uri()), Node.ANY, Node.ANY);
    }

    @Override
    public Object invokeGetter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(Object v) {
        throw new UnsupportedOperationException();
    }

    public boolean isDate() {
        return this.property.getPropertyType().equals(Date.class);
    }

    @Override
    public boolean isURI() {
        return this.property.getPropertyType().equals(URI.class);
    }

    @Override
    public boolean isPrimitive() {
        return PrimitiveWrapper.isPrimitive(this.property.getPropertyType());
    }

    @Override
    public boolean isCollection() {
        return this.property.getPropertyType().equals(Collection.class);
    }

    @Override
    public boolean isArray() {
        return this.property.getPropertyType().isArray();
    }

    @Override
    public Class<?> type() {
        return this.property.getPropertyType();
    }

    public TypeWrapper tw() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.property.getName();
    }

    @Override
    public Class<?> t() {
        ParameterizedType type = (ParameterizedType)this.property.getReadMethod().getGenericReturnType();
        return this.getGenericType(type);
    }

    @Override
    public boolean isInverse() {
        return this.isInverse(this.property.getReadMethod());
    }

    @Override
    public String inverseOf() {
        return this.inverseOf(this.property.getReadMethod());
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public AccessibleObject getAccessibleObject() {
        return this.property.getReadMethod();
    }
}

