/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.update.UpdateAction;
import java.util.LinkedList;
import thewebsemantic.RDF2Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sparql {
    public static <T> LinkedList<T> exec(Model m, Class<T> c, String query) {
        RDF2Bean reader = new RDF2Bean(m);
        QueryExecution qexec = Sparql.getQueryExec(m, query);
        LinkedList<T> beans = new LinkedList<T>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                beans.add(reader.load(c, Sparql.resource(results)));
            }
            LinkedList<T> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    public static <T> LinkedList<T> exec(Model m, Class<T> c, String query, QuerySolution initialBindings) {
        RDF2Bean reader = new RDF2Bean(m);
        QueryExecution qexec = Sparql.getQueryExec(m, query, initialBindings);
        LinkedList<T> beans = new LinkedList<T>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                beans.add(reader.load(c, Sparql.resource(results)));
            }
            LinkedList<T> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    public static <T> LinkedList<T> exec(RDF2Bean reader, Class<T> c, String query, QuerySolution initialBindings, int start, int max) {
        Model m = reader.getModel();
        QueryExecution qexec = Sparql.getQueryExec(m, query, initialBindings);
        LinkedList<T> beans = new LinkedList<T>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            int pos = 0;
            while (pos < start && results.hasNext()) {
                results.next();
                ++pos;
            }
            while (results.hasNext() && max != 0) {
                beans.add(reader.load(c, Sparql.resource(results)));
                --max;
            }
            LinkedList<T> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    public static <T> LinkedList<Resource> exec2(Model m, String query, QuerySolution initialBindings) {
        QueryExecution qexec = Sparql.getQueryExec(m, query, initialBindings);
        LinkedList<Resource> beans = new LinkedList<Resource>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                beans.add(Sparql.resource(results));
            }
            LinkedList<Resource> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    public static void update(Model m, String query, QuerySolution i) {
        UpdateAction.parseExecute((String)query, (Model)m, (QuerySolution)i);
    }

    private static QueryExecution getQueryExec(Model m, String query) {
        Query q = QueryFactory.create((String)query);
        return QueryExecutionFactory.create((Query)q, (Model)m);
    }

    private static QueryExecution getQueryExec(Model m, String query, QuerySolution i) {
        Query q = QueryFactory.create((String)query);
        return QueryExecutionFactory.create((Query)q, (Model)m, (QuerySolution)i);
    }

    private static Resource resource(ResultSet results) {
        return results.nextSolution().getResource("s");
    }
}

