/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.beans.BeanInfo;
import java.beans.MethodDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import thewebsemantic.DefaultTypeWrapper;
import thewebsemantic.EnumTypeWrapper;
import thewebsemantic.IdFieldTypeWrapper;
import thewebsemantic.IdMethodTypeWrapper;
import thewebsemantic.TypeWrapper;
import thewebsemantic.Uri;
import thewebsemantic.UriMethodTypeWrapper;
import thewebsemantic.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeWrapperFactory {
    public static Logger logger = Logger.getLogger("com.thewebsemantic");

    public static TypeWrapper newwrapper(Class<?> c) {
        Field[] fields;
        BeanInfo info = TypeWrapper.beanInfo(c);
        if (c.isEnum()) {
            return new EnumTypeWrapper(c);
        }
        MethodDescriptor[] methodDescriptorArray = info.getMethodDescriptors();
        int n = methodDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDescriptor md = methodDescriptorArray[n2];
            if (TypeWrapperFactory.isId(md)) {
                return new IdMethodTypeWrapper(c, md.getMethod());
            }
            if (TypeWrapperFactory.isUri(md)) {
                return new UriMethodTypeWrapper(c, md.getMethod());
            }
            ++n2;
        }
        Field[] fieldArray = fields = Util.getDeclaredFields(c);
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            Field f = fieldArray[n];
            if (TypeWrapperFactory.isId(f)) {
                return new IdFieldTypeWrapper(c, f, fields);
            }
            ++n;
        }
        return new DefaultTypeWrapper(c);
    }

    private static boolean isId(AccessibleObject m) {
        Annotation[] annotationArray = m.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if ("Id".equals(a.annotationType().getSimpleName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isId(MethodDescriptor md) {
        return TypeWrapperFactory.isId(md.getMethod());
    }

    private static boolean isUri(Method m) {
        return m.isAnnotationPresent(Uri.class);
    }

    private static boolean isUri(MethodDescriptor md) {
        return TypeWrapperFactory.isUri(md.getMethod());
    }
}

