/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.util.ResourceBundle;
import thewebsemantic.TypeWrapper;
import thewebsemantic.ValuesContext;
import thewebsemantic.binder.Binder;
import thewebsemantic.binder.BinderImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base {
    public static final String JAVACLASS = "http://thewebsemantic.com/javaclass";
    public static final String SEQUENCE = "http://thewebsemantic.com/sequence";
    ResourceBundle bundle = ResourceBundle.getBundle("thewebsemantic.messages");
    protected OntModel om;
    protected Model m;
    protected Binder binder;
    protected Property javaclass;
    protected Property sequence;

    protected Base(Model m) {
        this.m = m;
        this.binder = BinderImp.instance();
        if (m instanceof OntModel) {
            this.om = (OntModel)m;
        }
        m.enterCriticalSection(false);
        this.javaclass = m.createProperty(JAVACLASS);
        this.sequence = m.createProperty(SEQUENCE);
        this.javaclass.addProperty(RDF.type, (RDFNode)OWL.AnnotationProperty);
        m.leaveCriticalSection();
    }

    protected Property toRdfProperty(ValuesContext ctx) {
        return ctx.existsInModel(this.m) ? ctx.property(this.m) : this.applyEntailments(ctx);
    }

    private Property applyEntailments(ValuesContext ctx) {
        if (this.om == null) {
            return this.m.getProperty(ctx.uri());
        }
        OntProperty op = this.om.createOntProperty(ctx.uri());
        if (ctx.isSymmetric()) {
            op.convertToSymmetricProperty();
        } else if (ctx.isTransitive()) {
            op.convertToTransitiveProperty();
        } else if (ctx.isInverse()) {
            TypeWrapper type = TypeWrapper.wrap(ctx.t());
            ValuesContext inverse = type.getProperty(ctx.inverseOf());
            op.addInverseOf(inverse.property((Model)this.om));
        }
        return op;
    }

    protected Class<?> t(PropertyDescriptor propDesc) {
        ParameterizedType type = (ParameterizedType)propDesc.getReadMethod().getGenericReturnType();
        return type == null ? NullType.class : (Class)type.getActualTypeArguments()[0];
    }

    protected boolean isBound(Object o) {
        return this.binder.isBound(o.getClass());
    }

    public Model getModel() {
        return this.m;
    }

    class NullType {
        NullType() {
        }
    }
}

