/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import com.hp.hpl.jena.rdf.model.Resource;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import thewebsemantic.AnnotationHelper;
import thewebsemantic.Bean2RDF;
import thewebsemantic.Namespace;
import thewebsemantic.NullPropertyContext;
import thewebsemantic.NullRdfProperty;
import thewebsemantic.PropertyContext;
import thewebsemantic.RdfProperty;
import thewebsemantic.Transient;
import thewebsemantic.TypeWrapperFactory;
import thewebsemantic.Util;
import thewebsemantic.ValuesContext;
import thewebsemantic.binding.Persistable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeWrapper {
    public static final String JENABEAN_PREFIX = "jenabean.prefix";
    private String NS;
    protected Class<?> c;
    protected BeanInfo info;
    protected Constructor<?> constructor;
    protected PropertyDescriptor[] descriptors;
    private static HashMap<Class<?>, TypeWrapper> cache = new HashMap();
    private String prefix = System.getProperty("jenabean.prefix");

    protected <T> TypeWrapper(Class<T> c) {
        this.c = c;
        this.info = TypeWrapper.beanInfo(c);
        Namespace nsa = c.getAnnotation(Namespace.class);
        this.NS = nsa != null ? nsa.value() : this.getNamespaceFromPackage(c);
        try {
            this.constructor = c.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cache.put(c, this);
    }

    private String getNamespaceFromPackage(Class<?> c) {
        return c.getPackage() == null ? "http://default.package/" : "http://" + c.getPackage().getName() + '/';
    }

    public static synchronized TypeWrapper type(Object o) {
        if (o instanceof Persistable) {
            return TypeWrapper.wrap(o.getClass().getSuperclass());
        }
        return TypeWrapper.wrap(o.getClass());
    }

    public static String getId(Object o) {
        return TypeWrapper.type(o).id(o);
    }

    public static ValuesContext[] valueContexts(Object o) {
        return TypeWrapper.type(o).getValueContexts(o);
    }

    public ValuesContext[] getValueContexts(Object o) {
        ArrayList<PropertyContext> values = new ArrayList<PropertyContext>();
        PropertyDescriptor[] propertyDescriptorArray = this.descriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor property = propertyDescriptorArray[n2];
            if (!property.getReadMethod().isAnnotationPresent(Transient.class)) {
                values.add(new PropertyContext(o, property));
            }
            ++n2;
        }
        return values.toArray(new ValuesContext[0]);
    }

    public ValuesContext getProperty(String name) {
        PropertyDescriptor[] propertyDescriptorArray = this.descriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor p = propertyDescriptorArray[n2];
            if (p.getName().equals(name)) {
                return new NullPropertyContext(this, p);
            }
            ++n2;
        }
        return null;
    }

    public static synchronized TypeWrapper wrap(Class<?> c) {
        return cache.containsKey(c) ? cache.get(c) : TypeWrapperFactory.newwrapper(c);
    }

    public String typeUri() {
        return String.valueOf(this.NS) + Util.getRdfType(this.c);
    }

    public static String typeUri(Class<?> c) {
        return TypeWrapper.wrap(c).typeUri();
    }

    protected PropertyDescriptor[] descriptors() {
        if (this.descriptors == null) {
            LinkedList<PropertyDescriptor> results = new LinkedList<PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptorArray = this.info.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor p = propertyDescriptorArray[n2];
                if (p.getWriteMethod() != null && p.getReadMethod() != null) {
                    results.add(p);
                }
                ++n2;
            }
            this.descriptors = results.toArray(new PropertyDescriptor[0]);
        }
        return this.descriptors;
    }

    public String[] collections() {
        LinkedList<String> results = new LinkedList<String>();
        PropertyDescriptor[] propertyDescriptorArray = this.info.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor p = propertyDescriptorArray[n2];
            if (p.getWriteMethod() != null && p.getPropertyType().equals(Collection.class)) {
                results.add(p.getName());
            }
            ++n2;
        }
        return results.toArray(new String[0]);
    }

    public String namespace() {
        return this.NS;
    }

    public abstract String uri(String var1);

    public String uri(Object bean) {
        return this.uri(this.id(bean));
    }

    public String uri(AccessibleObject m, String name) {
        RdfProperty rdf = TypeWrapper.getRDFAnnotation(m);
        return "".equals(rdf.value()) ? this.namingPatternUri(name) : rdf.value();
    }

    protected static RdfProperty getRDFAnnotation(AccessibleObject m) {
        return m.isAnnotationPresent(RdfProperty.class) ? m.getAnnotation(RdfProperty.class) : new NullRdfProperty();
    }

    private String namingPatternUri(String name) {
        return String.valueOf(this.namespace()) + this.prefix(name);
    }

    private String prefix(String p) {
        return this.prefix != null ? String.valueOf(this.prefix) + Util.toProperCase(p) : p;
    }

    public static String instanceURI(Object bean) {
        return TypeWrapper.type(bean).uri(bean);
    }

    public abstract String id(Object var1);

    protected static BeanInfo beanInfo(Class<?> c) {
        try {
            return Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    protected String invokeMethod(Object bean, Method me) {
        try {
            Object o = me.invoke(bean, new Object[0]);
            return o == null ? null : o.toString();
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Failed invoking method " + me.getName() + " on class " + bean.getClass(), e);
            return null;
        }
    }

    public final Object toBean(Resource source) {
        return this.toBean(source.getURI());
    }

    public Object toBean(String uri) {
        try {
            return this.constructor != null ? this.constructor.newInstance(Util.last(uri)) : this.c.newInstance();
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Exception caught while invoking default constructor on " + this.c, e);
            return null;
        }
    }

    public abstract Object toProxyBean(Resource var1, AnnotationHelper var2);
}

