/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.SDBException;

public enum SAPStorageType {
    row{

        @Override
        public String getStorageName() {
            return "ROW";
        }
    }
    ,
    column{

        @Override
        public String getStorageName() {
            return "COLUMN";
        }
    };


    public abstract String getStorageName();

    public static SAPStorageType convert(String storageName) {
        if (SAPStorageType.check(storageName, row)) {
            return row;
        }
        if (SAPStorageType.check(storageName, column)) {
            return column;
        }
        throw new SDBException("Can't turn '" + storageName + "' into a storage type");
    }

    private static boolean check(String storageName, SAPStorageType t) {
        return storageName.equalsIgnoreCase(t.getStorageName());
    }
}

